// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The private link service connection status.
 */
public final class PrivateLinkServiceConnectionStateStatus
    extends ExpandableStringEnum<PrivateLinkServiceConnectionStateStatus> {
    /**
     * Static value Approved for PrivateLinkServiceConnectionStateStatus.
     */
    public static final PrivateLinkServiceConnectionStateStatus APPROVED = fromString("Approved");

    /**
     * Static value Pending for PrivateLinkServiceConnectionStateStatus.
     */
    public static final PrivateLinkServiceConnectionStateStatus PENDING = fromString("Pending");

    /**
     * Static value Rejected for PrivateLinkServiceConnectionStateStatus.
     */
    public static final PrivateLinkServiceConnectionStateStatus REJECTED = fromString("Rejected");

    /**
     * Static value Disconnected for PrivateLinkServiceConnectionStateStatus.
     */
    public static final PrivateLinkServiceConnectionStateStatus DISCONNECTED = fromString("Disconnected");

    /**
     * Creates a new instance of PrivateLinkServiceConnectionStateStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PrivateLinkServiceConnectionStateStatus() {
    }

    /**
     * Creates or finds a PrivateLinkServiceConnectionStateStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PrivateLinkServiceConnectionStateStatus.
     */
    public static PrivateLinkServiceConnectionStateStatus fromString(String name) {
        return fromString(name, PrivateLinkServiceConnectionStateStatus.class);
    }

    /**
     * Gets known PrivateLinkServiceConnectionStateStatus values.
     * 
     * @return known PrivateLinkServiceConnectionStateStatus values.
     */
    public static Collection<PrivateLinkServiceConnectionStateStatus> values() {
        return values(PrivateLinkServiceConnectionStateStatus.class);
    }
}
