// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The min capacity capability.
 */
@Fluent
public final class MinCapacityCapability implements JsonSerializable<MinCapacityCapability> {
    /*
     * Min capacity value
     */
    private Double value;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of MinCapacityCapability class.
     */
    public MinCapacityCapability() {
    }

    /**
     * Get the value property: Min capacity value.
     * 
     * @return the value value.
     */
    public Double value() {
        return this.value;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the MinCapacityCapability object itself.
     */
    public MinCapacityCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MinCapacityCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MinCapacityCapability if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MinCapacityCapability.
     */
    public static MinCapacityCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MinCapacityCapability deserializedMinCapacityCapability = new MinCapacityCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedMinCapacityCapability.value = reader.getNullable(JsonReader::getDouble);
                } else if ("status".equals(fieldName)) {
                    deserializedMinCapacityCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedMinCapacityCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMinCapacityCapability;
        });
    }
}
