// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Pairs of Managed Instances in the failover group.
 */
@Fluent
public final class ManagedInstancePairInfo implements JsonSerializable<ManagedInstancePairInfo> {
    /*
     * Id of Primary Managed Instance in pair.
     */
    private String primaryManagedInstanceId;

    /*
     * Id of Partner Managed Instance in pair.
     */
    private String partnerManagedInstanceId;

    /**
     * Creates an instance of ManagedInstancePairInfo class.
     */
    public ManagedInstancePairInfo() {
    }

    /**
     * Get the primaryManagedInstanceId property: Id of Primary Managed Instance in pair.
     * 
     * @return the primaryManagedInstanceId value.
     */
    public String primaryManagedInstanceId() {
        return this.primaryManagedInstanceId;
    }

    /**
     * Set the primaryManagedInstanceId property: Id of Primary Managed Instance in pair.
     * 
     * @param primaryManagedInstanceId the primaryManagedInstanceId value to set.
     * @return the ManagedInstancePairInfo object itself.
     */
    public ManagedInstancePairInfo withPrimaryManagedInstanceId(String primaryManagedInstanceId) {
        this.primaryManagedInstanceId = primaryManagedInstanceId;
        return this;
    }

    /**
     * Get the partnerManagedInstanceId property: Id of Partner Managed Instance in pair.
     * 
     * @return the partnerManagedInstanceId value.
     */
    public String partnerManagedInstanceId() {
        return this.partnerManagedInstanceId;
    }

    /**
     * Set the partnerManagedInstanceId property: Id of Partner Managed Instance in pair.
     * 
     * @param partnerManagedInstanceId the partnerManagedInstanceId value to set.
     * @return the ManagedInstancePairInfo object itself.
     */
    public ManagedInstancePairInfo withPartnerManagedInstanceId(String partnerManagedInstanceId) {
        this.partnerManagedInstanceId = partnerManagedInstanceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryManagedInstanceId", this.primaryManagedInstanceId);
        jsonWriter.writeStringField("partnerManagedInstanceId", this.partnerManagedInstanceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstancePairInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstancePairInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstancePairInfo.
     */
    public static ManagedInstancePairInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstancePairInfo deserializedManagedInstancePairInfo = new ManagedInstancePairInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primaryManagedInstanceId".equals(fieldName)) {
                    deserializedManagedInstancePairInfo.primaryManagedInstanceId = reader.getString();
                } else if ("partnerManagedInstanceId".equals(fieldName)) {
                    deserializedManagedInstancePairInfo.partnerManagedInstanceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstancePairInfo;
        });
    }
}
