// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the information necessary to perform a managed database move.
 */
@Fluent
public final class ManagedDatabaseMoveDefinition implements JsonSerializable<ManagedDatabaseMoveDefinition> {
    /*
     * The destination managed database ID
     */
    private String destinationManagedDatabaseId;

    /**
     * Creates an instance of ManagedDatabaseMoveDefinition class.
     */
    public ManagedDatabaseMoveDefinition() {
    }

    /**
     * Get the destinationManagedDatabaseId property: The destination managed database ID.
     * 
     * @return the destinationManagedDatabaseId value.
     */
    public String destinationManagedDatabaseId() {
        return this.destinationManagedDatabaseId;
    }

    /**
     * Set the destinationManagedDatabaseId property: The destination managed database ID.
     * 
     * @param destinationManagedDatabaseId the destinationManagedDatabaseId value to set.
     * @return the ManagedDatabaseMoveDefinition object itself.
     */
    public ManagedDatabaseMoveDefinition withDestinationManagedDatabaseId(String destinationManagedDatabaseId) {
        this.destinationManagedDatabaseId = destinationManagedDatabaseId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destinationManagedDatabaseId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationManagedDatabaseId in model ManagedDatabaseMoveDefinition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedDatabaseMoveDefinition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("destinationManagedDatabaseId", this.destinationManagedDatabaseId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedDatabaseMoveDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedDatabaseMoveDefinition if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedDatabaseMoveDefinition.
     */
    public static ManagedDatabaseMoveDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedDatabaseMoveDefinition deserializedManagedDatabaseMoveDefinition
                = new ManagedDatabaseMoveDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destinationManagedDatabaseId".equals(fieldName)) {
                    deserializedManagedDatabaseMoveDefinition.destinationManagedDatabaseId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedDatabaseMoveDefinition;
        });
    }
}
