// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without
 * SQL license price).
 */
public final class InstancePoolLicenseType extends ExpandableStringEnum<InstancePoolLicenseType> {
    /**
     * Static value LicenseIncluded for InstancePoolLicenseType.
     */
    public static final InstancePoolLicenseType LICENSE_INCLUDED = fromString("LicenseIncluded");

    /**
     * Static value BasePrice for InstancePoolLicenseType.
     */
    public static final InstancePoolLicenseType BASE_PRICE = fromString("BasePrice");

    /**
     * Creates a new instance of InstancePoolLicenseType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public InstancePoolLicenseType() {
    }

    /**
     * Creates or finds a InstancePoolLicenseType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding InstancePoolLicenseType.
     */
    public static InstancePoolLicenseType fromString(String name) {
        return fromString(name, InstancePoolLicenseType.class);
    }

    /**
     * Gets known InstancePoolLicenseType values.
     * 
     * @return known InstancePoolLicenseType values.
     */
    public static Collection<InstancePoolLicenseType> values() {
        return values(InstancePoolLicenseType.class);
    }
}
