// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.EncryptionProtectorInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of server encryption protectors.
 */
@Immutable
public final class EncryptionProtectorListResult implements JsonSerializable<EncryptionProtectorListResult> {
    /*
     * Array of results.
     */
    private List<EncryptionProtectorInner> value;

    /*
     * Link to retrieve next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of EncryptionProtectorListResult class.
     */
    public EncryptionProtectorListResult() {
    }

    /**
     * Get the value property: Array of results.
     * 
     * @return the value value.
     */
    public List<EncryptionProtectorInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to retrieve next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionProtectorListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionProtectorListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionProtectorListResult.
     */
    public static EncryptionProtectorListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionProtectorListResult deserializedEncryptionProtectorListResult
                = new EncryptionProtectorListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EncryptionProtectorInner> value
                        = reader.readArray(reader1 -> EncryptionProtectorInner.fromJson(reader1));
                    deserializedEncryptionProtectorListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEncryptionProtectorListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionProtectorListResult;
        });
    }
}
