// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.UUID;

/**
 * Azure Active Directory identity configuration for a resource.
 */
@Immutable
public final class DatabaseUserIdentity implements JsonSerializable<DatabaseUserIdentity> {
    /*
     * The Azure Active Directory principal id.
     */
    private UUID principalId;

    /*
     * The Azure Active Directory client id.
     */
    private UUID clientId;

    /**
     * Creates an instance of DatabaseUserIdentity class.
     */
    public DatabaseUserIdentity() {
    }

    /**
     * Get the principalId property: The Azure Active Directory principal id.
     * 
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: The Azure Active Directory client id.
     * 
     * @return the clientId value.
     */
    public UUID clientId() {
        return this.clientId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseUserIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseUserIdentity if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseUserIdentity.
     */
    public static DatabaseUserIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseUserIdentity deserializedDatabaseUserIdentity = new DatabaseUserIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedDatabaseUserIdentity.principalId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("clientId".equals(fieldName)) {
                    deserializedDatabaseUserIdentity.clientId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseUserIdentity;
        });
    }
}
