// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines values for DatabaseState.
 */
public final class DatabaseState extends ExpandableStringEnum<DatabaseState> {
    /**
     * Static value All for DatabaseState.
     */
    public static final DatabaseState ALL = fromString("All");

    /**
     * Static value Live for DatabaseState.
     */
    public static final DatabaseState LIVE = fromString("Live");

    /**
     * Static value Deleted for DatabaseState.
     */
    public static final DatabaseState DELETED = fromString("Deleted");

    /**
     * Creates a new instance of DatabaseState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DatabaseState() {
    }

    /**
     * Creates or finds a DatabaseState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DatabaseState.
     */
    public static DatabaseState fromString(String name) {
        return fromString(name, DatabaseState.class);
    }

    /**
     * Gets known DatabaseState values.
     * 
     * @return known DatabaseState values.
     */
    public static Collection<DatabaseState> values() {
        return values(DatabaseState.class);
    }
}
