// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Automatic tuning properties for individual advisors.
 */
@Fluent
public final class AutomaticTuningOptions implements JsonSerializable<AutomaticTuningOptions> {
    /*
     * Automatic tuning option desired state.
     */
    private AutomaticTuningOptionModeDesired desiredState;

    /*
     * Automatic tuning option actual state.
     */
    private AutomaticTuningOptionModeActual actualState;

    /*
     * Reason code if desired and actual state are different.
     */
    private Integer reasonCode;

    /*
     * Reason description if desired and actual state are different.
     */
    private AutomaticTuningDisabledReason reasonDesc;

    /**
     * Creates an instance of AutomaticTuningOptions class.
     */
    public AutomaticTuningOptions() {
    }

    /**
     * Get the desiredState property: Automatic tuning option desired state.
     * 
     * @return the desiredState value.
     */
    public AutomaticTuningOptionModeDesired desiredState() {
        return this.desiredState;
    }

    /**
     * Set the desiredState property: Automatic tuning option desired state.
     * 
     * @param desiredState the desiredState value to set.
     * @return the AutomaticTuningOptions object itself.
     */
    public AutomaticTuningOptions withDesiredState(AutomaticTuningOptionModeDesired desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    /**
     * Get the actualState property: Automatic tuning option actual state.
     * 
     * @return the actualState value.
     */
    public AutomaticTuningOptionModeActual actualState() {
        return this.actualState;
    }

    /**
     * Get the reasonCode property: Reason code if desired and actual state are different.
     * 
     * @return the reasonCode value.
     */
    public Integer reasonCode() {
        return this.reasonCode;
    }

    /**
     * Get the reasonDesc property: Reason description if desired and actual state are different.
     * 
     * @return the reasonDesc value.
     */
    public AutomaticTuningDisabledReason reasonDesc() {
        return this.reasonDesc;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("desiredState", this.desiredState == null ? null : this.desiredState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutomaticTuningOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutomaticTuningOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutomaticTuningOptions.
     */
    public static AutomaticTuningOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutomaticTuningOptions deserializedAutomaticTuningOptions = new AutomaticTuningOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("desiredState".equals(fieldName)) {
                    deserializedAutomaticTuningOptions.desiredState
                        = AutomaticTuningOptionModeDesired.fromString(reader.getString());
                } else if ("actualState".equals(fieldName)) {
                    deserializedAutomaticTuningOptions.actualState
                        = AutomaticTuningOptionModeActual.fromString(reader.getString());
                } else if ("reasonCode".equals(fieldName)) {
                    deserializedAutomaticTuningOptions.reasonCode = reader.getNullable(JsonReader::getInt);
                } else if ("reasonDesc".equals(fieldName)) {
                    deserializedAutomaticTuningOptions.reasonDesc
                        = AutomaticTuningDisabledReason.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutomaticTuningOptions;
        });
    }
}
