// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

/**
 * Gets the resource from which current value of auto-execute status is inherited. Auto-execute status can be set on
 * (and inherited from) different levels in the resource hierarchy. Possible values are 'Subscription', 'Server',
 * 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
 */
public enum AutoExecuteStatusInheritedFrom {
    /**
     * Enum value Default.
     */
    DEFAULT("Default"),

    /**
     * Enum value Subscription.
     */
    SUBSCRIPTION("Subscription"),

    /**
     * Enum value Server.
     */
    SERVER("Server"),

    /**
     * Enum value ElasticPool.
     */
    ELASTIC_POOL("ElasticPool"),

    /**
     * Enum value Database.
     */
    DATABASE("Database");

    /**
     * The actual serialized value for a AutoExecuteStatusInheritedFrom instance.
     */
    private final String value;

    AutoExecuteStatusInheritedFrom(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AutoExecuteStatusInheritedFrom instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AutoExecuteStatusInheritedFrom object, or null if unable to parse.
     */
    public static AutoExecuteStatusInheritedFrom fromString(String value) {
        if (value == null) {
            return null;
        }
        AutoExecuteStatusInheritedFrom[] items = AutoExecuteStatusInheritedFrom.values();
        for (AutoExecuteStatusInheritedFrom item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
