// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.DistributedAvailabilityGroupsClient;
import com.azure.resourcemanager.sql.fluent.models.DistributedAvailabilityGroupInner;
import com.azure.resourcemanager.sql.models.DistributedAvailabilityGroupsListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DistributedAvailabilityGroupsClient.
 */
public final class DistributedAvailabilityGroupsClientImpl implements DistributedAvailabilityGroupsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DistributedAvailabilityGroupsService service;

    /**
     * The service client containing this operation class.
     */
    private final SqlManagementClientImpl client;

    /**
     * Initializes an instance of DistributedAvailabilityGroupsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DistributedAvailabilityGroupsClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(DistributedAvailabilityGroupsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SqlManagementClientDistributedAvailabilityGroups to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SqlManagementClientD")
    public interface DistributedAvailabilityGroupsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DistributedAvailabilityGroupsListResult>> listByInstance(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups/{distributedAvailabilityGroupName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DistributedAvailabilityGroupInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("distributedAvailabilityGroupName") String distributedAvailabilityGroupName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups/{distributedAvailabilityGroupName}")
        @ExpectedResponses({ 200, 201, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("distributedAvailabilityGroupName") String distributedAvailabilityGroupName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DistributedAvailabilityGroupInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups/{distributedAvailabilityGroupName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("distributedAvailabilityGroupName") String distributedAvailabilityGroupName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/distributedAvailabilityGroups/{distributedAvailabilityGroupName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("distributedAvailabilityGroupName") String distributedAvailabilityGroupName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DistributedAvailabilityGroupInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DistributedAvailabilityGroupsListResult>> listByInstanceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets a list of a distributed availability groups in instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DistributedAvailabilityGroupInner>>
        listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByInstance(this.client.getEndpoint(), resourceGroupName,
                managedInstanceName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<DistributedAvailabilityGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of a distributed availability groups in instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DistributedAvailabilityGroupInner>>
        listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of a distributed availability groups in instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DistributedAvailabilityGroupInner> listByInstanceAsync(String resourceGroupName,
        String managedInstanceName) {
        return new PagedFlux<>(() -> listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName),
            nextLink -> listByInstanceNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of a distributed availability groups in instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DistributedAvailabilityGroupInner> listByInstanceAsync(String resourceGroupName,
        String managedInstanceName, Context context) {
        return new PagedFlux<>(() -> listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, context),
            nextLink -> listByInstanceNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of a distributed availability groups in instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DistributedAvailabilityGroupInner> listByInstance(String resourceGroupName,
        String managedInstanceName) {
        return new PagedIterable<>(listByInstanceAsync(resourceGroupName, managedInstanceName));
    }

    /**
     * Gets a list of a distributed availability groups in instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of a distributed availability groups in instance as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DistributedAvailabilityGroupInner> listByInstance(String resourceGroupName,
        String managedInstanceName, Context context) {
        return new PagedIterable<>(listByInstanceAsync(resourceGroupName, managedInstanceName, context));
    }

    /**
     * Gets a distributed availability group info.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DistributedAvailabilityGroupInner>> getWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
                distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a distributed availability group info.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DistributedAvailabilityGroupInner>> getWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets a distributed availability group info.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DistributedAvailabilityGroupInner> getAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName) {
        return getWithResponseAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a distributed availability group info.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DistributedAvailabilityGroupInner> getWithResponse(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName, Context context) {
        return getWithResponseAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, context)
            .block();
    }

    /**
     * Gets a distributed availability group info.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a distributed availability group info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DistributedAvailabilityGroupInner get(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName) {
        return getWithResponse(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, Context.NONE)
            .getValue();
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), resourceGroupName,
                managedInstanceName, distributedAvailabilityGroupName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters,
            accept, context);
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName,
            String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, parameters);
        return this.client.<DistributedAvailabilityGroupInner, DistributedAvailabilityGroupInner>getLroResult(mono,
            this.client.getHttpPipeline(), DistributedAvailabilityGroupInner.class,
            DistributedAvailabilityGroupInner.class, this.client.getContext());
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName,
            String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, parameters, context);
        return this.client.<DistributedAvailabilityGroupInner, DistributedAvailabilityGroupInner>getLroResult(mono,
            this.client.getHttpPipeline(), DistributedAvailabilityGroupInner.class,
            DistributedAvailabilityGroupInner.class, context);
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginCreateOrUpdate(String resourceGroupName, String managedInstanceName,
            String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName,
                parameters)
            .getSyncPoller();
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginCreateOrUpdate(String resourceGroupName, String managedInstanceName,
            String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName,
                parameters, context)
            .getSyncPoller();
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DistributedAvailabilityGroupInner> createOrUpdateAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName,
            parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DistributedAvailabilityGroupInner> createOrUpdateAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName,
            parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DistributedAvailabilityGroupInner createOrUpdate(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters) {
        return createOrUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters)
            .block();
    }

    /**
     * Creates a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DistributedAvailabilityGroupInner createOrUpdate(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters, Context context) {
        return createOrUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters,
            context).block();
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
                distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName)
            .getSyncPoller();
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, context)
            .getSyncPoller();
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName) {
        return beginDeleteAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, Context context) {
        return beginDeleteAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName) {
        deleteAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName).block();
    }

    /**
     * Drops a distributed availability group between Sql On-Prem and Sql Managed Instance.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName,
        Context context) {
        deleteAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, context).block();
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
                distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (distributedAvailabilityGroupName == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter distributedAvailabilityGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters,
            accept, context);
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginUpdateAsync(String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName,
            DistributedAvailabilityGroupInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, parameters);
        return this.client.<DistributedAvailabilityGroupInner, DistributedAvailabilityGroupInner>getLroResult(mono,
            this.client.getHttpPipeline(), DistributedAvailabilityGroupInner.class,
            DistributedAvailabilityGroupInner.class, this.client.getContext());
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner>
        beginUpdateAsync(String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName,
            DistributedAvailabilityGroupInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, managedInstanceName,
            distributedAvailabilityGroupName, parameters, context);
        return this.client.<DistributedAvailabilityGroupInner, DistributedAvailabilityGroupInner>getLroResult(mono,
            this.client.getHttpPipeline(), DistributedAvailabilityGroupInner.class,
            DistributedAvailabilityGroupInner.class, context);
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginUpdate(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters) {
        return this
            .beginUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters)
            .getSyncPoller();
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of distributed availability group between box and Sql Managed
     * Instance.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DistributedAvailabilityGroupInner>, DistributedAvailabilityGroupInner> beginUpdate(
        String resourceGroupName, String managedInstanceName, String distributedAvailabilityGroupName,
        DistributedAvailabilityGroupInner parameters, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters,
                context)
            .getSyncPoller();
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DistributedAvailabilityGroupInner> updateAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters) {
        return beginUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DistributedAvailabilityGroupInner> updateAsync(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters, Context context) {
        return beginUpdateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DistributedAvailabilityGroupInner update(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters) {
        return updateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters)
            .block();
    }

    /**
     * Updates a distributed availability group replication mode.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param parameters The distributed availability group info.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return distributed availability group between box and Sql Managed Instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DistributedAvailabilityGroupInner update(String resourceGroupName, String managedInstanceName,
        String distributedAvailabilityGroupName, DistributedAvailabilityGroupInner parameters, Context context) {
        return updateAsync(resourceGroupName, managedInstanceName, distributedAvailabilityGroupName, parameters,
            context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of distributed availability groups in instance along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DistributedAvailabilityGroupInner>> listByInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByInstanceNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DistributedAvailabilityGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of distributed availability groups in instance along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DistributedAvailabilityGroupInner>> listByInstanceNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByInstanceNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
