// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Workload classifier operations for a data warehouse.
 */
@Fluent
public final class WorkloadClassifierInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private WorkloadClassifierProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of WorkloadClassifierInner class.
     */
    public WorkloadClassifierInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private WorkloadClassifierProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the memberName property: The workload classifier member name.
     * 
     * @return the memberName value.
     */
    public String memberName() {
        return this.innerProperties() == null ? null : this.innerProperties().memberName();
    }

    /**
     * Set the memberName property: The workload classifier member name.
     * 
     * @param memberName the memberName value to set.
     * @return the WorkloadClassifierInner object itself.
     */
    public WorkloadClassifierInner withMemberName(String memberName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadClassifierProperties();
        }
        this.innerProperties().withMemberName(memberName);
        return this;
    }

    /**
     * Get the label property: The workload classifier label.
     * 
     * @return the label value.
     */
    public String label() {
        return this.innerProperties() == null ? null : this.innerProperties().label();
    }

    /**
     * Set the label property: The workload classifier label.
     * 
     * @param label the label value to set.
     * @return the WorkloadClassifierInner object itself.
     */
    public WorkloadClassifierInner withLabel(String label) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadClassifierProperties();
        }
        this.innerProperties().withLabel(label);
        return this;
    }

    /**
     * Get the context property: The workload classifier context.
     * 
     * @return the context value.
     */
    public String context() {
        return this.innerProperties() == null ? null : this.innerProperties().context();
    }

    /**
     * Set the context property: The workload classifier context.
     * 
     * @param context the context value to set.
     * @return the WorkloadClassifierInner object itself.
     */
    public WorkloadClassifierInner withContext(String context) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadClassifierProperties();
        }
        this.innerProperties().withContext(context);
        return this;
    }

    /**
     * Get the startTime property: The workload classifier start time for classification.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Set the startTime property: The workload classifier start time for classification.
     * 
     * @param startTime the startTime value to set.
     * @return the WorkloadClassifierInner object itself.
     */
    public WorkloadClassifierInner withStartTime(String startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadClassifierProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the endTime property: The workload classifier end time for classification.
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Set the endTime property: The workload classifier end time for classification.
     * 
     * @param endTime the endTime value to set.
     * @return the WorkloadClassifierInner object itself.
     */
    public WorkloadClassifierInner withEndTime(String endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadClassifierProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    /**
     * Get the importance property: The workload classifier importance.
     * 
     * @return the importance value.
     */
    public String importance() {
        return this.innerProperties() == null ? null : this.innerProperties().importance();
    }

    /**
     * Set the importance property: The workload classifier importance.
     * 
     * @param importance the importance value to set.
     * @return the WorkloadClassifierInner object itself.
     */
    public WorkloadClassifierInner withImportance(String importance) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkloadClassifierProperties();
        }
        this.innerProperties().withImportance(importance);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkloadClassifierInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkloadClassifierInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkloadClassifierInner.
     */
    public static WorkloadClassifierInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkloadClassifierInner deserializedWorkloadClassifierInner = new WorkloadClassifierInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedWorkloadClassifierInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedWorkloadClassifierInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedWorkloadClassifierInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedWorkloadClassifierInner.innerProperties = WorkloadClassifierProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkloadClassifierInner;
        });
    }
}
