// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VirtualNetworkRuleState;
import java.io.IOException;

/**
 * Properties of a virtual network rule.
 */
@Fluent
public final class VirtualNetworkRuleProperties implements JsonSerializable<VirtualNetworkRuleProperties> {
    /*
     * The ARM resource id of the virtual network subnet.
     */
    private String virtualNetworkSubnetId;

    /*
     * Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    private Boolean ignoreMissingVnetServiceEndpoint;

    /*
     * Virtual Network Rule State
     */
    private VirtualNetworkRuleState state;

    /**
     * Creates an instance of VirtualNetworkRuleProperties class.
     */
    public VirtualNetworkRuleProperties() {
    }

    /**
     * Get the virtualNetworkSubnetId property: The ARM resource id of the virtual network subnet.
     * 
     * @return the virtualNetworkSubnetId value.
     */
    public String virtualNetworkSubnetId() {
        return this.virtualNetworkSubnetId;
    }

    /**
     * Set the virtualNetworkSubnetId property: The ARM resource id of the virtual network subnet.
     * 
     * @param virtualNetworkSubnetId the virtualNetworkSubnetId value to set.
     * @return the VirtualNetworkRuleProperties object itself.
     */
    public VirtualNetworkRuleProperties withVirtualNetworkSubnetId(String virtualNetworkSubnetId) {
        this.virtualNetworkSubnetId = virtualNetworkSubnetId;
        return this;
    }

    /**
     * Get the ignoreMissingVnetServiceEndpoint property: Create firewall rule before the virtual network has vnet
     * service endpoint enabled.
     * 
     * @return the ignoreMissingVnetServiceEndpoint value.
     */
    public Boolean ignoreMissingVnetServiceEndpoint() {
        return this.ignoreMissingVnetServiceEndpoint;
    }

    /**
     * Set the ignoreMissingVnetServiceEndpoint property: Create firewall rule before the virtual network has vnet
     * service endpoint enabled.
     * 
     * @param ignoreMissingVnetServiceEndpoint the ignoreMissingVnetServiceEndpoint value to set.
     * @return the VirtualNetworkRuleProperties object itself.
     */
    public VirtualNetworkRuleProperties withIgnoreMissingVnetServiceEndpoint(Boolean ignoreMissingVnetServiceEndpoint) {
        this.ignoreMissingVnetServiceEndpoint = ignoreMissingVnetServiceEndpoint;
        return this;
    }

    /**
     * Get the state property: Virtual Network Rule State.
     * 
     * @return the state value.
     */
    public VirtualNetworkRuleState state() {
        return this.state;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualNetworkSubnetId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property virtualNetworkSubnetId in model VirtualNetworkRuleProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkRuleProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualNetworkSubnetId", this.virtualNetworkSubnetId);
        jsonWriter.writeBooleanField("ignoreMissingVnetServiceEndpoint", this.ignoreMissingVnetServiceEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkRuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkRuleProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualNetworkRuleProperties.
     */
    public static VirtualNetworkRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkRuleProperties deserializedVirtualNetworkRuleProperties = new VirtualNetworkRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualNetworkSubnetId".equals(fieldName)) {
                    deserializedVirtualNetworkRuleProperties.virtualNetworkSubnetId = reader.getString();
                } else if ("ignoreMissingVnetServiceEndpoint".equals(fieldName)) {
                    deserializedVirtualNetworkRuleProperties.ignoreMissingVnetServiceEndpoint
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("state".equals(fieldName)) {
                    deserializedVirtualNetworkRuleProperties.state
                        = VirtualNetworkRuleState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkRuleProperties;
        });
    }
}
