// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a TDE certificate.
 */
@Fluent
public final class TdeCertificateProperties implements JsonSerializable<TdeCertificateProperties> {
    /*
     * The base64 encoded certificate private blob.
     */
    private String privateBlob;

    /*
     * The certificate password.
     */
    private String certPassword;

    /**
     * Creates an instance of TdeCertificateProperties class.
     */
    public TdeCertificateProperties() {
    }

    /**
     * Get the privateBlob property: The base64 encoded certificate private blob.
     * 
     * @return the privateBlob value.
     */
    public String privateBlob() {
        return this.privateBlob;
    }

    /**
     * Set the privateBlob property: The base64 encoded certificate private blob.
     * 
     * @param privateBlob the privateBlob value to set.
     * @return the TdeCertificateProperties object itself.
     */
    public TdeCertificateProperties withPrivateBlob(String privateBlob) {
        this.privateBlob = privateBlob;
        return this;
    }

    /**
     * Get the certPassword property: The certificate password.
     * 
     * @return the certPassword value.
     */
    public String certPassword() {
        return this.certPassword;
    }

    /**
     * Set the certPassword property: The certificate password.
     * 
     * @param certPassword the certPassword value to set.
     * @return the TdeCertificateProperties object itself.
     */
    public TdeCertificateProperties withCertPassword(String certPassword) {
        this.certPassword = certPassword;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateBlob() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property privateBlob in model TdeCertificateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TdeCertificateProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateBlob", this.privateBlob);
        jsonWriter.writeStringField("certPassword", this.certPassword);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TdeCertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TdeCertificateProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TdeCertificateProperties.
     */
    public static TdeCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TdeCertificateProperties deserializedTdeCertificateProperties = new TdeCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateBlob".equals(fieldName)) {
                    deserializedTdeCertificateProperties.privateBlob = reader.getString();
                } else if ("certPassword".equals(fieldName)) {
                    deserializedTdeCertificateProperties.certPassword = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTdeCertificateProperties;
        });
    }
}
