// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SyncFullSchemaTable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Properties of the database full schema.
 */
@Immutable
public final class SyncFullSchemaPropertiesInner implements JsonSerializable<SyncFullSchemaPropertiesInner> {
    /*
     * List of tables in the database full schema.
     */
    private List<SyncFullSchemaTable> tables;

    /*
     * Last update time of the database schema.
     */
    private OffsetDateTime lastUpdateTime;

    /**
     * Creates an instance of SyncFullSchemaPropertiesInner class.
     */
    public SyncFullSchemaPropertiesInner() {
    }

    /**
     * Get the tables property: List of tables in the database full schema.
     * 
     * @return the tables value.
     */
    public List<SyncFullSchemaTable> tables() {
        return this.tables;
    }

    /**
     * Get the lastUpdateTime property: Last update time of the database schema.
     * 
     * @return the lastUpdateTime value.
     */
    public OffsetDateTime lastUpdateTime() {
        return this.lastUpdateTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tables() != null) {
            tables().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncFullSchemaPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncFullSchemaPropertiesInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncFullSchemaPropertiesInner.
     */
    public static SyncFullSchemaPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncFullSchemaPropertiesInner deserializedSyncFullSchemaPropertiesInner
                = new SyncFullSchemaPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tables".equals(fieldName)) {
                    List<SyncFullSchemaTable> tables
                        = reader.readArray(reader1 -> SyncFullSchemaTable.fromJson(reader1));
                    deserializedSyncFullSchemaPropertiesInner.tables = tables;
                } else if ("lastUpdateTime".equals(fieldName)) {
                    deserializedSyncFullSchemaPropertiesInner.lastUpdateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncFullSchemaPropertiesInner;
        });
    }
}
