// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import java.io.IOException;

/**
 * Properties of a server Vulnerability Assessment.
 */
@Fluent
public final class ServerVulnerabilityAssessmentProperties
    implements JsonSerializable<ServerVulnerabilityAssessmentProperties> {
    /*
     * A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
     */
    private String storageContainerPath;

    /*
     * A shared access signature (SAS Key) that has write access to the blob container specified in
     * 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
     * required. Applies only if the storage account is not behind a Vnet or a firewall
     */
    private String storageContainerSasKey;

    /*
     * Specifies the identifier key of the storage account for vulnerability assessment scan results. If
     * 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. Applies only if the storage
     * account is not behind a Vnet or a firewall
     */
    private String storageAccountAccessKey;

    /*
     * The recurring scans settings
     */
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;

    /**
     * Creates an instance of ServerVulnerabilityAssessmentProperties class.
     */
    public ServerVulnerabilityAssessmentProperties() {
    }

    /**
     * Get the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     * 
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Set the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).
     * 
     * @param storageContainerPath the storageContainerPath value to set.
     * @return the ServerVulnerabilityAssessmentProperties object itself.
     */
    public ServerVulnerabilityAssessmentProperties withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    /**
     * Get the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @return the storageContainerSasKey value.
     */
    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    /**
     * Set the storageContainerSasKey property: A shared access signature (SAS Key) that has write access to the blob
     * container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @param storageContainerSasKey the storageContainerSasKey value to set.
     * @return the ServerVulnerabilityAssessmentProperties object itself.
     */
    public ServerVulnerabilityAssessmentProperties withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     * Applies only if the storage account is not behind a Vnet or a firewall.
     * 
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the ServerVulnerabilityAssessmentProperties object itself.
     */
    public ServerVulnerabilityAssessmentProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the recurringScans property: The recurring scans settings.
     * 
     * @return the recurringScans value.
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    /**
     * Set the recurringScans property: The recurring scans settings.
     * 
     * @param recurringScans the recurringScans value to set.
     * @return the ServerVulnerabilityAssessmentProperties object itself.
     */
    public ServerVulnerabilityAssessmentProperties
        withRecurringScans(VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageContainerPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageContainerPath in model ServerVulnerabilityAssessmentProperties"));
        }
        if (recurringScans() != null) {
            recurringScans().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServerVulnerabilityAssessmentProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageContainerPath", this.storageContainerPath);
        jsonWriter.writeStringField("storageContainerSasKey", this.storageContainerSasKey);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeJsonField("recurringScans", this.recurringScans);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerVulnerabilityAssessmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerVulnerabilityAssessmentProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerVulnerabilityAssessmentProperties.
     */
    public static ServerVulnerabilityAssessmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerVulnerabilityAssessmentProperties deserializedServerVulnerabilityAssessmentProperties
                = new ServerVulnerabilityAssessmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageContainerPath".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.storageContainerPath = reader.getString();
                } else if ("storageContainerSasKey".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.storageContainerSasKey = reader.getString();
                } else if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.storageAccountAccessKey = reader.getString();
                } else if ("recurringScans".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.recurringScans
                        = VulnerabilityAssessmentRecurringScansProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerVulnerabilityAssessmentProperties;
        });
    }
}
