// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerConnectionType;
import java.io.IOException;

/**
 * A server connection policy.
 */
@Fluent
public final class ServerConnectionPolicyInner extends ProxyResource {
    /*
     * Resource location.
     */
    private String location;

    /*
     * Metadata used for the Azure portal experience.
     */
    private String kind;

    /*
     * Resource properties.
     */
    private ServerConnectionPolicyProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerConnectionPolicyInner class.
     */
    public ServerConnectionPolicyInner() {
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the kind property: Metadata used for the Azure portal experience.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ServerConnectionPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the connectionType property: The server connection type.
     * 
     * @return the connectionType value.
     */
    public ServerConnectionType connectionType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionType();
    }

    /**
     * Set the connectionType property: The server connection type.
     * 
     * @param connectionType the connectionType value to set.
     * @return the ServerConnectionPolicyInner object itself.
     */
    public ServerConnectionPolicyInner withConnectionType(ServerConnectionType connectionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerConnectionPolicyProperties();
        }
        this.innerProperties().withConnectionType(connectionType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerConnectionPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerConnectionPolicyInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerConnectionPolicyInner.
     */
    public static ServerConnectionPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerConnectionPolicyInner deserializedServerConnectionPolicyInner = new ServerConnectionPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.location = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.kind = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerConnectionPolicyInner.innerProperties
                        = ServerConnectionPolicyProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerConnectionPolicyInner;
        });
    }
}
