// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SensitivityLabelRank;
import java.io.IOException;

/**
 * A sensitivity label.
 */
@Fluent
public final class SensitivityLabelInner extends ProxyResource {
    /*
     * Resource that manages the sensitivity label.
     */
    private String managedBy;

    /*
     * Resource properties.
     */
    private SensitivityLabelProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SensitivityLabelInner class.
     */
    public SensitivityLabelInner() {
    }

    /**
     * Get the managedBy property: Resource that manages the sensitivity label.
     * 
     * @return the managedBy value.
     */
    public String managedBy() {
        return this.managedBy;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private SensitivityLabelProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the schemaName property: The schema name.
     * 
     * @return the schemaName value.
     */
    public String schemaName() {
        return this.innerProperties() == null ? null : this.innerProperties().schemaName();
    }

    /**
     * Get the tableName property: The table name.
     * 
     * @return the tableName value.
     */
    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    /**
     * Get the columnName property: The column name.
     * 
     * @return the columnName value.
     */
    public String columnName() {
        return this.innerProperties() == null ? null : this.innerProperties().columnName();
    }

    /**
     * Get the labelName property: The label name.
     * 
     * @return the labelName value.
     */
    public String labelName() {
        return this.innerProperties() == null ? null : this.innerProperties().labelName();
    }

    /**
     * Set the labelName property: The label name.
     * 
     * @param labelName the labelName value to set.
     * @return the SensitivityLabelInner object itself.
     */
    public SensitivityLabelInner withLabelName(String labelName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SensitivityLabelProperties();
        }
        this.innerProperties().withLabelName(labelName);
        return this;
    }

    /**
     * Get the labelId property: The label ID.
     * 
     * @return the labelId value.
     */
    public String labelId() {
        return this.innerProperties() == null ? null : this.innerProperties().labelId();
    }

    /**
     * Set the labelId property: The label ID.
     * 
     * @param labelId the labelId value to set.
     * @return the SensitivityLabelInner object itself.
     */
    public SensitivityLabelInner withLabelId(String labelId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SensitivityLabelProperties();
        }
        this.innerProperties().withLabelId(labelId);
        return this;
    }

    /**
     * Get the informationType property: The information type.
     * 
     * @return the informationType value.
     */
    public String informationType() {
        return this.innerProperties() == null ? null : this.innerProperties().informationType();
    }

    /**
     * Set the informationType property: The information type.
     * 
     * @param informationType the informationType value to set.
     * @return the SensitivityLabelInner object itself.
     */
    public SensitivityLabelInner withInformationType(String informationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SensitivityLabelProperties();
        }
        this.innerProperties().withInformationType(informationType);
        return this;
    }

    /**
     * Get the informationTypeId property: The information type ID.
     * 
     * @return the informationTypeId value.
     */
    public String informationTypeId() {
        return this.innerProperties() == null ? null : this.innerProperties().informationTypeId();
    }

    /**
     * Set the informationTypeId property: The information type ID.
     * 
     * @param informationTypeId the informationTypeId value to set.
     * @return the SensitivityLabelInner object itself.
     */
    public SensitivityLabelInner withInformationTypeId(String informationTypeId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SensitivityLabelProperties();
        }
        this.innerProperties().withInformationTypeId(informationTypeId);
        return this;
    }

    /**
     * Get the isDisabled property: Is sensitivity recommendation disabled. Applicable for recommended sensitivity label
     * only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
     * 
     * @return the isDisabled value.
     */
    public Boolean isDisabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isDisabled();
    }

    /**
     * Get the rank property: The rank property.
     * 
     * @return the rank value.
     */
    public SensitivityLabelRank rank() {
        return this.innerProperties() == null ? null : this.innerProperties().rank();
    }

    /**
     * Set the rank property: The rank property.
     * 
     * @param rank the rank value to set.
     * @return the SensitivityLabelInner object itself.
     */
    public SensitivityLabelInner withRank(SensitivityLabelRank rank) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SensitivityLabelProperties();
        }
        this.innerProperties().withRank(rank);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SensitivityLabelInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SensitivityLabelInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SensitivityLabelInner.
     */
    public static SensitivityLabelInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SensitivityLabelInner deserializedSensitivityLabelInner = new SensitivityLabelInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSensitivityLabelInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSensitivityLabelInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSensitivityLabelInner.type = reader.getString();
                } else if ("managedBy".equals(fieldName)) {
                    deserializedSensitivityLabelInner.managedBy = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSensitivityLabelInner.innerProperties = SensitivityLabelProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSensitivityLabelInner;
        });
    }
}
