// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SecurityEventSqlInjectionAdditionalProperties;
import com.azure.resourcemanager.sql.models.SecurityEventType;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * A security event.
 */
@Immutable
public final class SecurityEventInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private SecurityEventProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SecurityEventInner class.
     */
    public SecurityEventInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private SecurityEventProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the eventTime property: The time when the security event occurred.
     * 
     * @return the eventTime value.
     */
    public OffsetDateTime eventTime() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTime();
    }

    /**
     * Get the securityEventType property: The type of the security event.
     * 
     * @return the securityEventType value.
     */
    public SecurityEventType securityEventType() {
        return this.innerProperties() == null ? null : this.innerProperties().securityEventType();
    }

    /**
     * Get the subscription property: The subscription name.
     * 
     * @return the subscription value.
     */
    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    /**
     * Get the server property: The server name.
     * 
     * @return the server value.
     */
    public String server() {
        return this.innerProperties() == null ? null : this.innerProperties().server();
    }

    /**
     * Get the database property: The database name.
     * 
     * @return the database value.
     */
    public String database() {
        return this.innerProperties() == null ? null : this.innerProperties().database();
    }

    /**
     * Get the clientIp property: The IP address of the client who executed the statement.
     * 
     * @return the clientIp value.
     */
    public String clientIp() {
        return this.innerProperties() == null ? null : this.innerProperties().clientIp();
    }

    /**
     * Get the applicationName property: The application used to execute the statement.
     * 
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationName();
    }

    /**
     * Get the principalName property: The principal user who executed the statement.
     * 
     * @return the principalName value.
     */
    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    /**
     * Get the securityEventSqlInjectionAdditionalProperties property: The sql injection additional properties,
     * populated only if the type of the security event is sql injection.
     * 
     * @return the securityEventSqlInjectionAdditionalProperties value.
     */
    public SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties() {
        return this.innerProperties() == null
            ? null
            : this.innerProperties().securityEventSqlInjectionAdditionalProperties();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityEventInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityEventInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SecurityEventInner.
     */
    public static SecurityEventInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityEventInner deserializedSecurityEventInner = new SecurityEventInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSecurityEventInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSecurityEventInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSecurityEventInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSecurityEventInner.innerProperties = SecurityEventProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityEventInner;
        });
    }
}
