// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.RecommendedActionErrorInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionImpactRecord;
import com.azure.resourcemanager.sql.models.RecommendedActionImplementationInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionInitiatedBy;
import com.azure.resourcemanager.sql.models.RecommendedActionMetricInfo;
import com.azure.resourcemanager.sql.models.RecommendedActionStateInfo;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Database, Server or Elastic Pool Recommended Action.
 */
@Fluent
public final class RecommendedActionInner extends ProxyResource {
    /*
     * Resource kind.
     */
    private String kind;

    /*
     * Resource location.
     */
    private String location;

    /*
     * Resource properties.
     */
    private RecommendedActionProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RecommendedActionInner class.
     */
    public RecommendedActionInner() {
    }

    /**
     * Get the kind property: Resource kind.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private RecommendedActionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the recommendationReason property: Gets the reason for recommending this action. e.g., DuplicateIndex.
     * 
     * @return the recommendationReason value.
     */
    public String recommendationReason() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationReason();
    }

    /**
     * Get the validSince property: Gets the time since when this recommended action is valid.
     * 
     * @return the validSince value.
     */
    public OffsetDateTime validSince() {
        return this.innerProperties() == null ? null : this.innerProperties().validSince();
    }

    /**
     * Get the lastRefresh property: Gets time when this recommended action was last refreshed.
     * 
     * @return the lastRefresh value.
     */
    public OffsetDateTime lastRefresh() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRefresh();
    }

    /**
     * Get the state property: Gets the info of the current state the recommended action is in.
     * 
     * @return the state value.
     */
    public RecommendedActionStateInfo state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Gets the info of the current state the recommended action is in.
     * 
     * @param state the state value to set.
     * @return the RecommendedActionInner object itself.
     */
    public RecommendedActionInner withState(RecommendedActionStateInfo state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RecommendedActionProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the isExecutableAction property: Gets if this recommended action is actionable by user.
     * 
     * @return the isExecutableAction value.
     */
    public Boolean isExecutableAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isExecutableAction();
    }

    /**
     * Get the isRevertableAction property: Gets if changes applied by this recommended action can be reverted by user.
     * 
     * @return the isRevertableAction value.
     */
    public Boolean isRevertableAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isRevertableAction();
    }

    /**
     * Get the isArchivedAction property: Gets if this recommended action was suggested some time ago but user chose to
     * ignore this and system added a new recommended action again.
     * 
     * @return the isArchivedAction value.
     */
    public Boolean isArchivedAction() {
        return this.innerProperties() == null ? null : this.innerProperties().isArchivedAction();
    }

    /**
     * Get the executeActionStartTime property: Gets the time when system started applying this recommended action on
     * the user resource. e.g., index creation start time.
     * 
     * @return the executeActionStartTime value.
     */
    public OffsetDateTime executeActionStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionStartTime();
    }

    /**
     * Get the executeActionDuration property: Gets the time taken for applying this recommended action on user
     * resource. e.g., time taken for index creation.
     * 
     * @return the executeActionDuration value.
     */
    public Duration executeActionDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionDuration();
    }

    /**
     * Get the revertActionStartTime property: Gets the time when system started reverting changes of this recommended
     * action on user resource. e.g., time when index drop is executed.
     * 
     * @return the revertActionStartTime value.
     */
    public OffsetDateTime revertActionStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionStartTime();
    }

    /**
     * Get the revertActionDuration property: Gets the time taken for reverting changes of this recommended action on
     * user resource. e.g., time taken for dropping the created index.
     * 
     * @return the revertActionDuration value.
     */
    public Duration revertActionDuration() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionDuration();
    }

    /**
     * Get the executeActionInitiatedBy property: Gets if approval for applying this recommended action was given by
     * user/system.
     * 
     * @return the executeActionInitiatedBy value.
     */
    public RecommendedActionInitiatedBy executeActionInitiatedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionInitiatedBy();
    }

    /**
     * Get the executeActionInitiatedTime property: Gets the time when this recommended action was approved for
     * execution.
     * 
     * @return the executeActionInitiatedTime value.
     */
    public OffsetDateTime executeActionInitiatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().executeActionInitiatedTime();
    }

    /**
     * Get the revertActionInitiatedBy property: Gets if approval for reverting this recommended action was given by
     * user/system.
     * 
     * @return the revertActionInitiatedBy value.
     */
    public RecommendedActionInitiatedBy revertActionInitiatedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionInitiatedBy();
    }

    /**
     * Get the revertActionInitiatedTime property: Gets the time when this recommended action was approved for revert.
     * 
     * @return the revertActionInitiatedTime value.
     */
    public OffsetDateTime revertActionInitiatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().revertActionInitiatedTime();
    }

    /**
     * Get the score property: Gets the impact of this recommended action. Possible values are 1 - Low impact, 2 -
     * Medium Impact and 3 - High Impact.
     * 
     * @return the score value.
     */
    public Integer score() {
        return this.innerProperties() == null ? null : this.innerProperties().score();
    }

    /**
     * Get the implementationDetails property: Gets the implementation details of this recommended action for user to
     * apply it manually.
     * 
     * @return the implementationDetails value.
     */
    public RecommendedActionImplementationInfo implementationDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().implementationDetails();
    }

    /**
     * Get the errorDetails property: Gets the error details if and why this recommended action is put to error state.
     * 
     * @return the errorDetails value.
     */
    public RecommendedActionErrorInfo errorDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().errorDetails();
    }

    /**
     * Get the estimatedImpact property: Gets the estimated impact info for this recommended action e.g., Estimated CPU
     * gain, Estimated Disk Space change.
     * 
     * @return the estimatedImpact value.
     */
    public List<RecommendedActionImpactRecord> estimatedImpact() {
        return this.innerProperties() == null ? null : this.innerProperties().estimatedImpact();
    }

    /**
     * Get the observedImpact property: Gets the observed/actual impact info for this recommended action e.g., Actual
     * CPU gain, Actual Disk Space change.
     * 
     * @return the observedImpact value.
     */
    public List<RecommendedActionImpactRecord> observedImpact() {
        return this.innerProperties() == null ? null : this.innerProperties().observedImpact();
    }

    /**
     * Get the timeSeries property: Gets the time series info of metrics for this recommended action e.g., CPU
     * consumption time series.
     * 
     * @return the timeSeries value.
     */
    public List<RecommendedActionMetricInfo> timeSeries() {
        return this.innerProperties() == null ? null : this.innerProperties().timeSeries();
    }

    /**
     * Get the linkedObjects property: Gets the linked objects, if any.
     * 
     * @return the linkedObjects value.
     */
    public List<String> linkedObjects() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedObjects();
    }

    /**
     * Get the details property: Gets additional details specific to this recommended action.
     * 
     * @return the details value.
     */
    public Map<String, Object> details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendedActionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendedActionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecommendedActionInner.
     */
    public static RecommendedActionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendedActionInner deserializedRecommendedActionInner = new RecommendedActionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRecommendedActionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRecommendedActionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRecommendedActionInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedRecommendedActionInner.kind = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedRecommendedActionInner.location = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRecommendedActionInner.innerProperties = RecommendedActionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendedActionInner;
        });
    }
}
