// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionState;
import java.io.IOException;

/**
 * A managed database transparent data encryption state.
 */
@Fluent
public final class ManagedTransparentDataEncryptionInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ManagedTransparentDataEncryptionProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedTransparentDataEncryptionInner class.
     */
    public ManagedTransparentDataEncryptionInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ManagedTransparentDataEncryptionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the state property: Specifies the state of the transparent data encryption.
     * 
     * @return the state value.
     */
    public TransparentDataEncryptionState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Specifies the state of the transparent data encryption.
     * 
     * @param state the state value to set.
     * @return the ManagedTransparentDataEncryptionInner object itself.
     */
    public ManagedTransparentDataEncryptionInner withState(TransparentDataEncryptionState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedTransparentDataEncryptionProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedTransparentDataEncryptionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedTransparentDataEncryptionInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedTransparentDataEncryptionInner.
     */
    public static ManagedTransparentDataEncryptionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedTransparentDataEncryptionInner deserializedManagedTransparentDataEncryptionInner
                = new ManagedTransparentDataEncryptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedTransparentDataEncryptionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedTransparentDataEncryptionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedTransparentDataEncryptionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedTransparentDataEncryptionInner.innerProperties
                        = ManagedTransparentDataEncryptionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedTransparentDataEncryptionInner;
        });
    }
}
