// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagedInstanceOperationParametersPair;
import com.azure.resourcemanager.sql.models.ManagedInstanceOperationSteps;
import com.azure.resourcemanager.sql.models.ManagementOperationState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The properties of a managed instance operation.
 */
@Immutable
public final class ManagedInstanceOperationProperties implements JsonSerializable<ManagedInstanceOperationProperties> {
    /*
     * The name of the managed instance the operation is being performed on.
     */
    private String managedInstanceName;

    /*
     * The name of operation.
     */
    private String operation;

    /*
     * The friendly name of operation.
     */
    private String operationFriendlyName;

    /*
     * The percentage of the operation completed.
     */
    private Integer percentComplete;

    /*
     * The operation start time.
     */
    private OffsetDateTime startTime;

    /*
     * The operation state.
     */
    private ManagementOperationState state;

    /*
     * The operation error code.
     */
    private Integer errorCode;

    /*
     * The operation error description.
     */
    private String errorDescription;

    /*
     * The operation error severity.
     */
    private Integer errorSeverity;

    /*
     * Whether or not the error is a user error.
     */
    private Boolean isUserError;

    /*
     * The estimated completion time of the operation.
     */
    private OffsetDateTime estimatedCompletionTime;

    /*
     * The operation description.
     */
    private String description;

    /*
     * Whether the operation can be cancelled.
     */
    private Boolean isCancellable;

    /*
     * The operation parameters.
     */
    private ManagedInstanceOperationParametersPair operationParameters;

    /*
     * The operation steps.
     */
    private ManagedInstanceOperationSteps operationSteps;

    /**
     * Creates an instance of ManagedInstanceOperationProperties class.
     */
    public ManagedInstanceOperationProperties() {
    }

    /**
     * Get the managedInstanceName property: The name of the managed instance the operation is being performed on.
     * 
     * @return the managedInstanceName value.
     */
    public String managedInstanceName() {
        return this.managedInstanceName;
    }

    /**
     * Get the operation property: The name of operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Get the operationFriendlyName property: The friendly name of operation.
     * 
     * @return the operationFriendlyName value.
     */
    public String operationFriendlyName() {
        return this.operationFriendlyName;
    }

    /**
     * Get the percentComplete property: The percentage of the operation completed.
     * 
     * @return the percentComplete value.
     */
    public Integer percentComplete() {
        return this.percentComplete;
    }

    /**
     * Get the startTime property: The operation start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the state property: The operation state.
     * 
     * @return the state value.
     */
    public ManagementOperationState state() {
        return this.state;
    }

    /**
     * Get the errorCode property: The operation error code.
     * 
     * @return the errorCode value.
     */
    public Integer errorCode() {
        return this.errorCode;
    }

    /**
     * Get the errorDescription property: The operation error description.
     * 
     * @return the errorDescription value.
     */
    public String errorDescription() {
        return this.errorDescription;
    }

    /**
     * Get the errorSeverity property: The operation error severity.
     * 
     * @return the errorSeverity value.
     */
    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    /**
     * Get the isUserError property: Whether or not the error is a user error.
     * 
     * @return the isUserError value.
     */
    public Boolean isUserError() {
        return this.isUserError;
    }

    /**
     * Get the estimatedCompletionTime property: The estimated completion time of the operation.
     * 
     * @return the estimatedCompletionTime value.
     */
    public OffsetDateTime estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    /**
     * Get the description property: The operation description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the isCancellable property: Whether the operation can be cancelled.
     * 
     * @return the isCancellable value.
     */
    public Boolean isCancellable() {
        return this.isCancellable;
    }

    /**
     * Get the operationParameters property: The operation parameters.
     * 
     * @return the operationParameters value.
     */
    public ManagedInstanceOperationParametersPair operationParameters() {
        return this.operationParameters;
    }

    /**
     * Get the operationSteps property: The operation steps.
     * 
     * @return the operationSteps value.
     */
    public ManagedInstanceOperationSteps operationSteps() {
        return this.operationSteps;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (operationParameters() != null) {
            operationParameters().validate();
        }
        if (operationSteps() != null) {
            operationSteps().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceOperationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceOperationProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceOperationProperties.
     */
    public static ManagedInstanceOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceOperationProperties deserializedManagedInstanceOperationProperties
                = new ManagedInstanceOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("managedInstanceName".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.managedInstanceName = reader.getString();
                } else if ("operation".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operation = reader.getString();
                } else if ("operationFriendlyName".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operationFriendlyName = reader.getString();
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.percentComplete
                        = reader.getNullable(JsonReader::getInt);
                } else if ("startTime".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("state".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.state
                        = ManagementOperationState.fromString(reader.getString());
                } else if ("errorCode".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.errorCode = reader.getNullable(JsonReader::getInt);
                } else if ("errorDescription".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.errorDescription = reader.getString();
                } else if ("errorSeverity".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.errorSeverity
                        = reader.getNullable(JsonReader::getInt);
                } else if ("isUserError".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.isUserError
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("estimatedCompletionTime".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.estimatedCompletionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("description".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.description = reader.getString();
                } else if ("isCancellable".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.isCancellable
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("operationParameters".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operationParameters
                        = ManagedInstanceOperationParametersPair.fromJson(reader);
                } else if ("operationSteps".equals(fieldName)) {
                    deserializedManagedInstanceOperationProperties.operationSteps
                        = ManagedInstanceOperationSteps.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceOperationProperties;
        });
    }
}
