// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.ManagedInstanceExternalAdministrator;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstancePecProperty;
import com.azure.resourcemanager.sql.models.ManagedInstancePropertiesProvisioningState;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.azure.resourcemanager.sql.models.ServicePrincipal;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * An Azure SQL managed instance.
 */
@Fluent
public final class ManagedInstanceInner extends Resource {
    /*
     * The Azure Active Directory identity of the managed instance.
     */
    private ResourceIdentity identity;

    /*
     * Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5, BC_G8IM, BC_G8IH
     */
    private Sku sku;

    /*
     * Resource properties.
     */
    private ManagedInstanceProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedInstanceInner class.
     */
    public ManagedInstanceInner() {
    }

    /**
     * Get the identity property: The Azure Active Directory identity of the managed instance.
     * 
     * @return the identity value.
     */
    public ResourceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The Azure Active Directory identity of the managed instance.
     * 
     * @param identity the identity value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the sku property: Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5,
     * BC_G8IM, BC_G8IH.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Managed instance SKU. Allowed values for sku.name: GP_Gen5, GP_G8IM, GP_G8IH, BC_Gen5,
     * BC_G8IM, BC_G8IH.
     * 
     * @param sku the sku value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ManagedInstanceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    public ManagedInstancePropertiesProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the managedInstanceCreateMode property: Specifies the mode of database creation.
     * 
     * Default: Regular instance creation.
     * 
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     * 
     * @return the managedInstanceCreateMode value.
     */
    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.innerProperties() == null ? null : this.innerProperties().managedInstanceCreateMode();
    }

    /**
     * Set the managedInstanceCreateMode property: Specifies the mode of database creation.
     * 
     * Default: Regular instance creation.
     * 
     * Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and
     * SourceManagedInstanceId must be specified.
     * 
     * @param managedInstanceCreateMode the managedInstanceCreateMode value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withManagedInstanceCreateMode(managedInstanceCreateMode);
        return this;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of the managed instance.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    /**
     * Get the administratorLogin property: Administrator username for the managed instance. Can only be specified when
     * the managed instance is being created (and is required for creation).
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: Administrator username for the managed instance. Can only be specified when
     * the managed instance is being created (and is required for creation).
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for managed instance
     * creation).
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for managed instance
     * creation).
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the subnetId property: Subnet resource ID for the managed instance.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    /**
     * Set the subnetId property: Subnet resource ID for the managed instance.
     * 
     * @param subnetId the subnetId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    /**
     * Get the state property: The state of the managed instance.
     * 
     * @return the state value.
     */
    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the licenseType property: The license type. Possible values are 'LicenseIncluded' (regular price inclusive of
     * a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     * 
     * @return the licenseType value.
     */
    public ManagedInstanceLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    /**
     * Set the licenseType property: The license type. Possible values are 'LicenseIncluded' (regular price inclusive of
     * a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     * 
     * @param licenseType the licenseType value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withLicenseType(ManagedInstanceLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    /**
     * Get the vCores property: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     * 
     * @return the vCores value.
     */
    public Integer vCores() {
        return this.innerProperties() == null ? null : this.innerProperties().vCores();
    }

    /**
     * Set the vCores property: The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
     * 
     * @param vCores the vCores value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    /**
     * Get the storageSizeInGB property: Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32
     * GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     * 
     * @return the storageSizeInGB value.
     */
    public Integer storageSizeInGB() {
        return this.innerProperties() == null ? null : this.innerProperties().storageSizeInGB();
    }

    /**
     * Set the storageSizeInGB property: Storage size in GB. Minimum value: 32. Maximum value: 16384. Increments of 32
     * GB allowed only. Maximum value depends on the selected hardware family and number of vCores.
     * 
     * @param storageSizeInGB the storageSizeInGB value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withStorageSizeInGB(Integer storageSizeInGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withStorageSizeInGB(storageSizeInGB);
        return this;
    }

    /**
     * Get the collation property: Collation of the managed instance.
     * 
     * @return the collation value.
     */
    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    /**
     * Set the collation property: Collation of the managed instance.
     * 
     * @param collation the collation value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    /**
     * Get the dnsZone property: The Dns Zone that the managed instance is in.
     * 
     * @return the dnsZone value.
     */
    public String dnsZone() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZone();
    }

    /**
     * Get the dnsZonePartner property: The resource id of another managed instance whose DNS zone this managed instance
     * will share after creation.
     * 
     * @return the dnsZonePartner value.
     */
    public String dnsZonePartner() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZonePartner();
    }

    /**
     * Set the dnsZonePartner property: The resource id of another managed instance whose DNS zone this managed instance
     * will share after creation.
     * 
     * @param dnsZonePartner the dnsZonePartner value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withDnsZonePartner(String dnsZonePartner) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withDnsZonePartner(dnsZonePartner);
        return this;
    }

    /**
     * Get the publicDataEndpointEnabled property: Whether or not the public data endpoint is enabled.
     * 
     * @return the publicDataEndpointEnabled value.
     */
    public Boolean publicDataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().publicDataEndpointEnabled();
    }

    /**
     * Set the publicDataEndpointEnabled property: Whether or not the public data endpoint is enabled.
     * 
     * @param publicDataEndpointEnabled the publicDataEndpointEnabled value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withPublicDataEndpointEnabled(publicDataEndpointEnabled);
        return this;
    }

    /**
     * Get the sourceManagedInstanceId property: The resource identifier of the source managed instance associated with
     * create operation of this instance.
     * 
     * @return the sourceManagedInstanceId value.
     */
    public String sourceManagedInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceManagedInstanceId();
    }

    /**
     * Set the sourceManagedInstanceId property: The resource identifier of the source managed instance associated with
     * create operation of this instance.
     * 
     * @param sourceManagedInstanceId the sourceManagedInstanceId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withSourceManagedInstanceId(String sourceManagedInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withSourceManagedInstanceId(sourceManagedInstanceId);
        return this;
    }

    /**
     * Get the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     * 
     * @return the restorePointInTime value.
     */
    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    /**
     * Set the restorePointInTime property: Specifies the point in time (ISO8601 format) of the source database that
     * will be restored to create the new database.
     * 
     * @param restorePointInTime the restorePointInTime value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    /**
     * Get the proxyOverride property: Connection type used for connecting to the instance.
     * 
     * @return the proxyOverride value.
     */
    public ManagedInstanceProxyOverride proxyOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().proxyOverride();
    }

    /**
     * Set the proxyOverride property: Connection type used for connecting to the instance.
     * 
     * @param proxyOverride the proxyOverride value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withProxyOverride(proxyOverride);
        return this;
    }

    /**
     * Get the timezoneId property: Id of the timezone. Allowed values are timezones supported by Windows.
     * Windows keeps details on supported timezones, including the id, in registry under
     * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
     * List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
     * 
     * @return the timezoneId value.
     */
    public String timezoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().timezoneId();
    }

    /**
     * Set the timezoneId property: Id of the timezone. Allowed values are timezones supported by Windows.
     * Windows keeps details on supported timezones, including the id, in registry under
     * KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
     * You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
     * List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     * An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
     * 
     * @param timezoneId the timezoneId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withTimezoneId(String timezoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withTimezoneId(timezoneId);
        return this;
    }

    /**
     * Get the instancePoolId property: The Id of the instance pool this managed server belongs to.
     * 
     * @return the instancePoolId value.
     */
    public String instancePoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().instancePoolId();
    }

    /**
     * Set the instancePoolId property: The Id of the instance pool this managed server belongs to.
     * 
     * @param instancePoolId the instancePoolId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withInstancePoolId(String instancePoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withInstancePoolId(instancePoolId);
        return this;
    }

    /**
     * Get the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this managed
     * instance.
     * 
     * @return the maintenanceConfigurationId value.
     */
    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    /**
     * Set the maintenanceConfigurationId property: Specifies maintenance configuration id to apply to this managed
     * instance.
     * 
     * @param maintenanceConfigurationId the maintenanceConfigurationId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections on a managed instance.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<ManagedInstancePecProperty> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Get the minimalTlsVersion property: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
     * 
     * @return the minimalTlsVersion value.
     */
    public String minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    /**
     * Set the minimalTlsVersion property: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
     * 
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withMinimalTlsVersion(String minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    /**
     * Get the currentBackupStorageRedundancy property: The storage account type used to store backups for this
     * instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage)
     * and GeoZone(GeoZoneRedundantStorage).
     * 
     * @return the currentBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().currentBackupStorageRedundancy();
    }

    /**
     * Get the requestedBackupStorageRedundancy property: The storage account type to be used to store backups for this
     * instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage)
     * and GeoZone(GeoZoneRedundantStorage).
     * 
     * @return the requestedBackupStorageRedundancy value.
     */
    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedBackupStorageRedundancy();
    }

    /**
     * Set the requestedBackupStorageRedundancy property: The storage account type to be used to store backups for this
     * instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage)
     * and GeoZone(GeoZoneRedundantStorage).
     * 
     * @param requestedBackupStorageRedundancy the requestedBackupStorageRedundancy value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner
        withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withRequestedBackupStorageRedundancy(requestedBackupStorageRedundancy);
        return this;
    }

    /**
     * Get the zoneRedundant property: Whether or not the multi-az is enabled.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    /**
     * Set the zoneRedundant property: Whether or not the multi-az is enabled.
     * 
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    /**
     * Get the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @return the primaryUserAssignedIdentityId value.
     */
    public String primaryUserAssignedIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryUserAssignedIdentityId();
    }

    /**
     * Set the primaryUserAssignedIdentityId property: The resource id of a user assigned identity to be used by
     * default.
     * 
     * @param primaryUserAssignedIdentityId the primaryUserAssignedIdentityId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withPrimaryUserAssignedIdentityId(primaryUserAssignedIdentityId);
        return this;
    }

    /**
     * Get the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @return the keyId value.
     */
    public String keyId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyId();
    }

    /**
     * Set the keyId property: A CMK URI of the key to use for encryption.
     * 
     * @param keyId the keyId value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withKeyId(String keyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withKeyId(keyId);
        return this;
    }

    /**
     * Get the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @return the administrators value.
     */
    public ManagedInstanceExternalAdministrator administrators() {
        return this.innerProperties() == null ? null : this.innerProperties().administrators();
    }

    /**
     * Set the administrators property: The Azure Active Directory administrator of the server.
     * 
     * @param administrators the administrators value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withAdministrators(ManagedInstanceExternalAdministrator administrators) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withAdministrators(administrators);
        return this;
    }

    /**
     * Get the servicePrincipal property: The managed instance's service principal.
     * 
     * @return the servicePrincipal value.
     */
    public ServicePrincipal servicePrincipal() {
        return this.innerProperties() == null ? null : this.innerProperties().servicePrincipal();
    }

    /**
     * Set the servicePrincipal property: The managed instance's service principal.
     * 
     * @param servicePrincipal the servicePrincipal value to set.
     * @return the ManagedInstanceInner object itself.
     */
    public ManagedInstanceInner withServicePrincipal(ServicePrincipal servicePrincipal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceProperties();
        }
        this.innerProperties().withServicePrincipal(servicePrincipal);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedInstanceInner.
     */
    public static ManagedInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceInner deserializedManagedInstanceInner = new ManagedInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedInstanceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedInstanceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedInstanceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedManagedInstanceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedInstanceInner.withTags(tags);
                } else if ("identity".equals(fieldName)) {
                    deserializedManagedInstanceInner.identity = ResourceIdentity.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedManagedInstanceInner.sku = Sku.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedInstanceInner.innerProperties = ManagedInstanceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceInner;
        });
    }
}
