// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a active directory only authentication for Managed Instance.
 */
@Fluent
public final class ManagedInstanceAzureADOnlyAuthProperties
    implements JsonSerializable<ManagedInstanceAzureADOnlyAuthProperties> {
    /*
     * Azure Active Directory only Authentication enabled.
     */
    private boolean azureADOnlyAuthentication;

    /**
     * Creates an instance of ManagedInstanceAzureADOnlyAuthProperties class.
     */
    public ManagedInstanceAzureADOnlyAuthProperties() {
    }

    /**
     * Get the azureADOnlyAuthentication property: Azure Active Directory only Authentication enabled.
     * 
     * @return the azureADOnlyAuthentication value.
     */
    public boolean azureADOnlyAuthentication() {
        return this.azureADOnlyAuthentication;
    }

    /**
     * Set the azureADOnlyAuthentication property: Azure Active Directory only Authentication enabled.
     * 
     * @param azureADOnlyAuthentication the azureADOnlyAuthentication value to set.
     * @return the ManagedInstanceAzureADOnlyAuthProperties object itself.
     */
    public ManagedInstanceAzureADOnlyAuthProperties withAzureADOnlyAuthentication(boolean azureADOnlyAuthentication) {
        this.azureADOnlyAuthentication = azureADOnlyAuthentication;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("azureADOnlyAuthentication", this.azureADOnlyAuthentication);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceAzureADOnlyAuthProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceAzureADOnlyAuthProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedInstanceAzureADOnlyAuthProperties.
     */
    public static ManagedInstanceAzureADOnlyAuthProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceAzureADOnlyAuthProperties deserializedManagedInstanceAzureADOnlyAuthProperties
                = new ManagedInstanceAzureADOnlyAuthProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureADOnlyAuthentication".equals(fieldName)) {
                    deserializedManagedInstanceAzureADOnlyAuthProperties.azureADOnlyAuthentication
                        = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceAzureADOnlyAuthProperties;
        });
    }
}
