// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.MaintenanceWindowTimeRange;
import java.io.IOException;
import java.util.List;

/**
 * Maintenance windows.
 */
@Fluent
public final class MaintenanceWindowsInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private MaintenanceWindowsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of MaintenanceWindowsInner class.
     */
    public MaintenanceWindowsInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private MaintenanceWindowsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the timeRanges property: The timeRanges property.
     * 
     * @return the timeRanges value.
     */
    public List<MaintenanceWindowTimeRange> timeRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().timeRanges();
    }

    /**
     * Set the timeRanges property: The timeRanges property.
     * 
     * @param timeRanges the timeRanges value to set.
     * @return the MaintenanceWindowsInner object itself.
     */
    public MaintenanceWindowsInner withTimeRanges(List<MaintenanceWindowTimeRange> timeRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MaintenanceWindowsProperties();
        }
        this.innerProperties().withTimeRanges(timeRanges);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaintenanceWindowsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaintenanceWindowsInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MaintenanceWindowsInner.
     */
    public static MaintenanceWindowsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaintenanceWindowsInner deserializedMaintenanceWindowsInner = new MaintenanceWindowsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMaintenanceWindowsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMaintenanceWindowsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMaintenanceWindowsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedMaintenanceWindowsInner.innerProperties = MaintenanceWindowsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaintenanceWindowsInner;
        });
    }
}
