// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobStepAction;
import com.azure.resourcemanager.sql.models.JobStepExecutionOptions;
import com.azure.resourcemanager.sql.models.JobStepOutput;
import java.io.IOException;

/**
 * Properties of a job step.
 */
@Fluent
public final class JobStepProperties implements JsonSerializable<JobStepProperties> {
    /*
     * The job step's index within the job. If not specified when creating the job step, it will be created as the last
     * step. If not specified when updating the job step, the step id is not modified.
     */
    private Integer stepId;

    /*
     * The resource ID of the target group that the job step will be executed on.
     */
    private String targetGroup;

    /*
     * The resource ID of the job credential that will be used to connect to the targets.
     */
    private String credential;

    /*
     * The action payload of the job step.
     */
    private JobStepAction action;

    /*
     * Output destination properties of the job step.
     */
    private JobStepOutput output;

    /*
     * Execution options for the job step.
     */
    private JobStepExecutionOptions executionOptions;

    /**
     * Creates an instance of JobStepProperties class.
     */
    public JobStepProperties() {
    }

    /**
     * Get the stepId property: The job step's index within the job. If not specified when creating the job step, it
     * will be created as the last step. If not specified when updating the job step, the step id is not modified.
     * 
     * @return the stepId value.
     */
    public Integer stepId() {
        return this.stepId;
    }

    /**
     * Set the stepId property: The job step's index within the job. If not specified when creating the job step, it
     * will be created as the last step. If not specified when updating the job step, the step id is not modified.
     * 
     * @param stepId the stepId value to set.
     * @return the JobStepProperties object itself.
     */
    public JobStepProperties withStepId(Integer stepId) {
        this.stepId = stepId;
        return this;
    }

    /**
     * Get the targetGroup property: The resource ID of the target group that the job step will be executed on.
     * 
     * @return the targetGroup value.
     */
    public String targetGroup() {
        return this.targetGroup;
    }

    /**
     * Set the targetGroup property: The resource ID of the target group that the job step will be executed on.
     * 
     * @param targetGroup the targetGroup value to set.
     * @return the JobStepProperties object itself.
     */
    public JobStepProperties withTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
        return this;
    }

    /**
     * Get the credential property: The resource ID of the job credential that will be used to connect to the targets.
     * 
     * @return the credential value.
     */
    public String credential() {
        return this.credential;
    }

    /**
     * Set the credential property: The resource ID of the job credential that will be used to connect to the targets.
     * 
     * @param credential the credential value to set.
     * @return the JobStepProperties object itself.
     */
    public JobStepProperties withCredential(String credential) {
        this.credential = credential;
        return this;
    }

    /**
     * Get the action property: The action payload of the job step.
     * 
     * @return the action value.
     */
    public JobStepAction action() {
        return this.action;
    }

    /**
     * Set the action property: The action payload of the job step.
     * 
     * @param action the action value to set.
     * @return the JobStepProperties object itself.
     */
    public JobStepProperties withAction(JobStepAction action) {
        this.action = action;
        return this;
    }

    /**
     * Get the output property: Output destination properties of the job step.
     * 
     * @return the output value.
     */
    public JobStepOutput output() {
        return this.output;
    }

    /**
     * Set the output property: Output destination properties of the job step.
     * 
     * @param output the output value to set.
     * @return the JobStepProperties object itself.
     */
    public JobStepProperties withOutput(JobStepOutput output) {
        this.output = output;
        return this;
    }

    /**
     * Get the executionOptions property: Execution options for the job step.
     * 
     * @return the executionOptions value.
     */
    public JobStepExecutionOptions executionOptions() {
        return this.executionOptions;
    }

    /**
     * Set the executionOptions property: Execution options for the job step.
     * 
     * @param executionOptions the executionOptions value to set.
     * @return the JobStepProperties object itself.
     */
    public JobStepProperties withExecutionOptions(JobStepExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetGroup() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property targetGroup in model JobStepProperties"));
        }
        if (credential() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property credential in model JobStepProperties"));
        }
        if (action() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property action in model JobStepProperties"));
        } else {
            action().validate();
        }
        if (output() != null) {
            output().validate();
        }
        if (executionOptions() != null) {
            executionOptions().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(JobStepProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetGroup", this.targetGroup);
        jsonWriter.writeStringField("credential", this.credential);
        jsonWriter.writeJsonField("action", this.action);
        jsonWriter.writeNumberField("stepId", this.stepId);
        jsonWriter.writeJsonField("output", this.output);
        jsonWriter.writeJsonField("executionOptions", this.executionOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of JobStepProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of JobStepProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the JobStepProperties.
     */
    public static JobStepProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JobStepProperties deserializedJobStepProperties = new JobStepProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetGroup".equals(fieldName)) {
                    deserializedJobStepProperties.targetGroup = reader.getString();
                } else if ("credential".equals(fieldName)) {
                    deserializedJobStepProperties.credential = reader.getString();
                } else if ("action".equals(fieldName)) {
                    deserializedJobStepProperties.action = JobStepAction.fromJson(reader);
                } else if ("stepId".equals(fieldName)) {
                    deserializedJobStepProperties.stepId = reader.getNullable(JsonReader::getInt);
                } else if ("output".equals(fieldName)) {
                    deserializedJobStepProperties.output = JobStepOutput.fromJson(reader);
                } else if ("executionOptions".equals(fieldName)) {
                    deserializedJobStepProperties.executionOptions = JobStepExecutionOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedJobStepProperties;
        });
    }
}
