// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.InstancePoolLicenseType;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.Map;

/**
 * An Azure SQL instance pool.
 */
@Fluent
public final class InstancePoolInner extends Resource {
    /*
     * The name and tier of the SKU.
     */
    private Sku sku;

    /*
     * Resource properties.
     */
    private InstancePoolProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of InstancePoolInner class.
     */
    public InstancePoolInner() {
    }

    /**
     * Get the sku property: The name and tier of the SKU.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The name and tier of the SKU.
     * 
     * @param sku the sku value to set.
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private InstancePoolProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public InstancePoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public InstancePoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the subnetId property: Resource ID of the subnet to place this instance pool in.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    /**
     * Set the subnetId property: Resource ID of the subnet to place this instance pool in.
     * 
     * @param subnetId the subnetId value to set.
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withSubnetId(String subnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withSubnetId(subnetId);
        return this;
    }

    /**
     * Get the vCores property: Count of vCores belonging to this instance pool.
     * 
     * @return the vCores value.
     */
    public Integer vCores() {
        return this.innerProperties() == null ? null : this.innerProperties().vCores();
    }

    /**
     * Set the vCores property: Count of vCores belonging to this instance pool.
     * 
     * @param vCores the vCores value to set.
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withVCores(Integer vCores) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withVCores(vCores);
        return this;
    }

    /**
     * Get the licenseType property: The license type. Possible values are 'LicenseIncluded' (price for SQL license is
     * included) and 'BasePrice' (without SQL license price).
     * 
     * @return the licenseType value.
     */
    public InstancePoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    /**
     * Set the licenseType property: The license type. Possible values are 'LicenseIncluded' (price for SQL license is
     * included) and 'BasePrice' (without SQL license price).
     * 
     * @param licenseType the licenseType value to set.
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withLicenseType(InstancePoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InstancePoolProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InstancePoolInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InstancePoolInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the InstancePoolInner.
     */
    public static InstancePoolInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InstancePoolInner deserializedInstancePoolInner = new InstancePoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedInstancePoolInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedInstancePoolInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedInstancePoolInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedInstancePoolInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedInstancePoolInner.withTags(tags);
                } else if ("sku".equals(fieldName)) {
                    deserializedInstancePoolInner.sku = Sku.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedInstancePoolInner.innerProperties = InstancePoolProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInstancePoolInner;
        });
    }
}
