// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.PrivateEndpointConnectionRequestStatus;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

/**
 * An ImportExport operation result resource.
 */
@Immutable
public final class ImportExportOperationResultInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ImportExportOperationResultProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ImportExportOperationResultInner class.
     */
    public ImportExportOperationResultInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ImportExportOperationResultProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the requestId property: Request Id.
     * 
     * @return the requestId value.
     */
    public UUID requestId() {
        return this.innerProperties() == null ? null : this.innerProperties().requestId();
    }

    /**
     * Get the requestType property: Request type.
     * 
     * @return the requestType value.
     */
    public String requestType() {
        return this.innerProperties() == null ? null : this.innerProperties().requestType();
    }

    /**
     * Get the queuedTime property: Queued time.
     * 
     * @return the queuedTime value.
     */
    public String queuedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().queuedTime();
    }

    /**
     * Get the lastModifiedTime property: Last modified time.
     * 
     * @return the lastModifiedTime value.
     */
    public String lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    /**
     * Get the blobUri property: Blob Uri.
     * 
     * @return the blobUri value.
     */
    public String blobUri() {
        return this.innerProperties() == null ? null : this.innerProperties().blobUri();
    }

    /**
     * Get the serverName property: Server name.
     * 
     * @return the serverName value.
     */
    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    /**
     * Get the databaseName property: Database name.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the status property: Operation status.
     * 
     * @return the status value.
     */
    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the errorMessage property: Error message.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().errorMessage();
    }

    /**
     * Get the privateEndpointConnections property: Gets the status of private endpoints associated with this request.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionRequestStatus> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImportExportOperationResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImportExportOperationResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImportExportOperationResultInner.
     */
    public static ImportExportOperationResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImportExportOperationResultInner deserializedImportExportOperationResultInner
                = new ImportExportOperationResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedImportExportOperationResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedImportExportOperationResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedImportExportOperationResultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedImportExportOperationResultInner.innerProperties
                        = ImportExportOperationResultProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImportExportOperationResultInner;
        });
    }
}
