// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.TableTemporalType;
import java.io.IOException;

/**
 * Database table properties.
 */
@Fluent
public final class DatabaseTableProperties implements JsonSerializable<DatabaseTableProperties> {
    /*
     * The table temporal type.
     */
    private TableTemporalType temporalType;

    /*
     * Whether or not the table is memory optimized.
     */
    private Boolean memoryOptimized;

    /**
     * Creates an instance of DatabaseTableProperties class.
     */
    public DatabaseTableProperties() {
    }

    /**
     * Get the temporalType property: The table temporal type.
     * 
     * @return the temporalType value.
     */
    public TableTemporalType temporalType() {
        return this.temporalType;
    }

    /**
     * Set the temporalType property: The table temporal type.
     * 
     * @param temporalType the temporalType value to set.
     * @return the DatabaseTableProperties object itself.
     */
    public DatabaseTableProperties withTemporalType(TableTemporalType temporalType) {
        this.temporalType = temporalType;
        return this;
    }

    /**
     * Get the memoryOptimized property: Whether or not the table is memory optimized.
     * 
     * @return the memoryOptimized value.
     */
    public Boolean memoryOptimized() {
        return this.memoryOptimized;
    }

    /**
     * Set the memoryOptimized property: Whether or not the table is memory optimized.
     * 
     * @param memoryOptimized the memoryOptimized value to set.
     * @return the DatabaseTableProperties object itself.
     */
    public DatabaseTableProperties withMemoryOptimized(Boolean memoryOptimized) {
        this.memoryOptimized = memoryOptimized;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("temporalType", this.temporalType == null ? null : this.temporalType.toString());
        jsonWriter.writeBooleanField("memoryOptimized", this.memoryOptimized);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseTableProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseTableProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseTableProperties.
     */
    public static DatabaseTableProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseTableProperties deserializedDatabaseTableProperties = new DatabaseTableProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("temporalType".equals(fieldName)) {
                    deserializedDatabaseTableProperties.temporalType = TableTemporalType.fromString(reader.getString());
                } else if ("memoryOptimized".equals(fieldName)) {
                    deserializedDatabaseTableProperties.memoryOptimized = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseTableProperties;
        });
    }
}
