// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AutomaticTuningMode;
import com.azure.resourcemanager.sql.models.AutomaticTuningOptions;
import java.io.IOException;
import java.util.Map;

/**
 * Database-level Automatic Tuning properties.
 */
@Fluent
public final class DatabaseAutomaticTuningProperties implements JsonSerializable<DatabaseAutomaticTuningProperties> {
    /*
     * Automatic tuning desired state.
     */
    private AutomaticTuningMode desiredState;

    /*
     * Automatic tuning actual state.
     */
    private AutomaticTuningMode actualState;

    /*
     * Automatic tuning options definition.
     */
    private Map<String, AutomaticTuningOptions> options;

    /**
     * Creates an instance of DatabaseAutomaticTuningProperties class.
     */
    public DatabaseAutomaticTuningProperties() {
    }

    /**
     * Get the desiredState property: Automatic tuning desired state.
     * 
     * @return the desiredState value.
     */
    public AutomaticTuningMode desiredState() {
        return this.desiredState;
    }

    /**
     * Set the desiredState property: Automatic tuning desired state.
     * 
     * @param desiredState the desiredState value to set.
     * @return the DatabaseAutomaticTuningProperties object itself.
     */
    public DatabaseAutomaticTuningProperties withDesiredState(AutomaticTuningMode desiredState) {
        this.desiredState = desiredState;
        return this;
    }

    /**
     * Get the actualState property: Automatic tuning actual state.
     * 
     * @return the actualState value.
     */
    public AutomaticTuningMode actualState() {
        return this.actualState;
    }

    /**
     * Get the options property: Automatic tuning options definition.
     * 
     * @return the options value.
     */
    public Map<String, AutomaticTuningOptions> options() {
        return this.options;
    }

    /**
     * Set the options property: Automatic tuning options definition.
     * 
     * @param options the options value to set.
     * @return the DatabaseAutomaticTuningProperties object itself.
     */
    public DatabaseAutomaticTuningProperties withOptions(Map<String, AutomaticTuningOptions> options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (options() != null) {
            options().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("desiredState", this.desiredState == null ? null : this.desiredState.toString());
        jsonWriter.writeMapField("options", this.options, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAutomaticTuningProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAutomaticTuningProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseAutomaticTuningProperties.
     */
    public static DatabaseAutomaticTuningProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAutomaticTuningProperties deserializedDatabaseAutomaticTuningProperties
                = new DatabaseAutomaticTuningProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("desiredState".equals(fieldName)) {
                    deserializedDatabaseAutomaticTuningProperties.desiredState
                        = AutomaticTuningMode.fromString(reader.getString());
                } else if ("actualState".equals(fieldName)) {
                    deserializedDatabaseAutomaticTuningProperties.actualState
                        = AutomaticTuningMode.fromString(reader.getString());
                } else if ("options".equals(fieldName)) {
                    Map<String, AutomaticTuningOptions> options
                        = reader.readMap(reader1 -> AutomaticTuningOptions.fromJson(reader1));
                    deserializedDatabaseAutomaticTuningProperties.options = options;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAutomaticTuningProperties;
        });
    }
}
