// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.sql.fluent.models.TimeZoneInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in TimeZonesClient.
 */
public interface TimeZonesClient {
    /**
     * Gets a list of managed instance time zones by location.
     * 
     * @param locationName The locationName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed instance time zones by location as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<TimeZoneInner> listByLocationAsync(String locationName);

    /**
     * Gets a list of managed instance time zones by location.
     * 
     * @param locationName The locationName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed instance time zones by location as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<TimeZoneInner> listByLocation(String locationName);

    /**
     * Gets a list of managed instance time zones by location.
     * 
     * @param locationName The locationName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed instance time zones by location as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<TimeZoneInner> listByLocation(String locationName, Context context);

    /**
     * Gets a managed instance time zone.
     * 
     * @param locationName The locationName parameter.
     * @param timeZoneId The timeZoneId parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance time zone along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TimeZoneInner>> getWithResponseAsync(String locationName, String timeZoneId);

    /**
     * Gets a managed instance time zone.
     * 
     * @param locationName The locationName parameter.
     * @param timeZoneId The timeZoneId parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance time zone on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TimeZoneInner> getAsync(String locationName, String timeZoneId);

    /**
     * Gets a managed instance time zone.
     * 
     * @param locationName The locationName parameter.
     * @param timeZoneId The timeZoneId parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance time zone along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TimeZoneInner> getWithResponse(String locationName, String timeZoneId, Context context);

    /**
     * Gets a managed instance time zone.
     * 
     * @param locationName The locationName parameter.
     * @param timeZoneId The timeZoneId parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed instance time zone.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TimeZoneInner get(String locationName, String timeZoneId);
}
