// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.models.ServerDevOpsAuditingSettingsInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ServerDevOpsAuditSettingsClient.
 */
public interface ServerDevOpsAuditSettingsClient {
    /**
     * Lists DevOps audit settings of a server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of server DevOps audit settings as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ServerDevOpsAuditingSettingsInner> listByServerAsync(String resourceGroupName, String serverName);

    /**
     * Lists DevOps audit settings of a server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of server DevOps audit settings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ServerDevOpsAuditingSettingsInner> listByServer(String resourceGroupName, String serverName);

    /**
     * Lists DevOps audit settings of a server.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of server DevOps audit settings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ServerDevOpsAuditingSettingsInner> listByServer(String resourceGroupName, String serverName,
        Context context);

    /**
     * Gets a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's DevOps audit settings along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServerDevOpsAuditingSettingsInner>> getWithResponseAsync(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName);

    /**
     * Gets a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's DevOps audit settings on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServerDevOpsAuditingSettingsInner> getAsync(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName);

    /**
     * Gets a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's DevOps audit settings along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServerDevOpsAuditingSettingsInner> getWithResponse(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName, Context context);

    /**
     * Gets a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server's DevOps audit settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerDevOpsAuditingSettingsInner get(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server DevOps auditing settings along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName, ServerDevOpsAuditingSettingsInner parameters);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a server DevOps auditing settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ServerDevOpsAuditingSettingsInner>, ServerDevOpsAuditingSettingsInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String devOpsAuditingSettingsName,
            ServerDevOpsAuditingSettingsInner parameters);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a server DevOps auditing settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ServerDevOpsAuditingSettingsInner>, ServerDevOpsAuditingSettingsInner> beginCreateOrUpdate(
        String resourceGroupName, String serverName, String devOpsAuditingSettingsName,
        ServerDevOpsAuditingSettingsInner parameters);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a server DevOps auditing settings.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ServerDevOpsAuditingSettingsInner>, ServerDevOpsAuditingSettingsInner> beginCreateOrUpdate(
        String resourceGroupName, String serverName, String devOpsAuditingSettingsName,
        ServerDevOpsAuditingSettingsInner parameters, Context context);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server DevOps auditing settings on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServerDevOpsAuditingSettingsInner> createOrUpdateAsync(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName, ServerDevOpsAuditingSettingsInner parameters);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server DevOps auditing settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerDevOpsAuditingSettingsInner createOrUpdate(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName, ServerDevOpsAuditingSettingsInner parameters);

    /**
     * Creates or updates a server's DevOps audit settings.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param devOpsAuditingSettingsName The name of the devops audit settings. This should always be 'default'.
     * @param parameters Properties of DevOps audit settings.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a server DevOps auditing settings.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServerDevOpsAuditingSettingsInner createOrUpdate(String resourceGroupName, String serverName,
        String devOpsAuditingSettingsName, ServerDevOpsAuditingSettingsInner parameters, Context context);
}
