// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentRuleBaselineInner;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentPolicyBaselineName;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.
 */
public interface ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient {
    /**
     * Gets a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName,
        String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName);

    /**
     * Gets a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName,
        String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName);

    /**
     * Gets a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> getWithResponse(String resourceGroupName,
        String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context);

    /**
     * Gets a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DatabaseVulnerabilityAssessmentRuleBaselineInner get(String resourceGroupName, String managedInstanceName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName);

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @param parameters The requested rule baseline resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String managedInstanceName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters);

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @param parameters The requested rule baseline resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName,
        String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName,
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters);

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @param parameters The requested rule baseline resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateWithResponse(String resourceGroupName,
        String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName,
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters, Context context);

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @param parameters The requested rule baseline resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DatabaseVulnerabilityAssessmentRuleBaselineInner createOrUpdate(String resourceGroupName,
        String managedInstanceName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName,
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters);

    /**
     * Removes the database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String managedInstanceName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName);

    /**
     * Removes the database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String managedInstanceName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName);

    /**
     * Removes the database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String managedInstanceName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName, Context context);

    /**
     * Removes the database's vulnerability assessment rule baseline.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     * database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String managedInstanceName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName);
}
