/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AdvancedThreatProtectionState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AdvancedThreatProtectionProperties
implements JsonSerializable<AdvancedThreatProtectionProperties> {
    private AdvancedThreatProtectionState state;
    private OffsetDateTime creationTime;
    private static final ClientLogger LOGGER = new ClientLogger(AdvancedThreatProtectionProperties.class);

    public AdvancedThreatProtectionState state() {
        return this.state;
    }

    public AdvancedThreatProtectionProperties withState(AdvancedThreatProtectionState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model AdvancedThreatProtectionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static AdvancedThreatProtectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AdvancedThreatProtectionProperties)jsonReader.readObject(reader -> {
            AdvancedThreatProtectionProperties deserializedAdvancedThreatProtectionProperties = new AdvancedThreatProtectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedAdvancedThreatProtectionProperties.state = AdvancedThreatProtectionState.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedAdvancedThreatProtectionProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdvancedThreatProtectionProperties;
        });
    }
}

