// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ManagedServerSecurityAlertPolicyInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of the managed Server's security alert policies.
 */
@Immutable
public final class ManagedServerSecurityAlertPolicyListResult
    implements JsonSerializable<ManagedServerSecurityAlertPolicyListResult> {
    /*
     * Array of results.
     */
    private List<ManagedServerSecurityAlertPolicyInner> value;

    /*
     * Link to retrieve next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ManagedServerSecurityAlertPolicyListResult class.
     */
    public ManagedServerSecurityAlertPolicyListResult() {
    }

    /**
     * Get the value property: Array of results.
     * 
     * @return the value value.
     */
    public List<ManagedServerSecurityAlertPolicyInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to retrieve next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedServerSecurityAlertPolicyListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedServerSecurityAlertPolicyListResult if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedServerSecurityAlertPolicyListResult.
     */
    public static ManagedServerSecurityAlertPolicyListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedServerSecurityAlertPolicyListResult deserializedManagedServerSecurityAlertPolicyListResult
                = new ManagedServerSecurityAlertPolicyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ManagedServerSecurityAlertPolicyInner> value
                        = reader.readArray(reader1 -> ManagedServerSecurityAlertPolicyInner.fromJson(reader1));
                    deserializedManagedServerSecurityAlertPolicyListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedManagedServerSecurityAlertPolicyListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedServerSecurityAlertPolicyListResult;
        });
    }
}
