// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ManagedInstancePrivateLinkServiceConnectionStateProperty model.
 */
@Fluent
public final class ManagedInstancePrivateLinkServiceConnectionStateProperty
    implements JsonSerializable<ManagedInstancePrivateLinkServiceConnectionStateProperty> {
    /*
     * The private link service connection status.
     */
    private String status;

    /*
     * The private link service connection description.
     */
    private String description;

    /*
     * The private link service connection description.
     */
    private String actionsRequired;

    /**
     * Creates an instance of ManagedInstancePrivateLinkServiceConnectionStateProperty class.
     */
    public ManagedInstancePrivateLinkServiceConnectionStateProperty() {
    }

    /**
     * Get the status property: The private link service connection status.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The private link service connection status.
     * 
     * @param status the status value to set.
     * @return the ManagedInstancePrivateLinkServiceConnectionStateProperty object itself.
     */
    public ManagedInstancePrivateLinkServiceConnectionStateProperty withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the description property: The private link service connection description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The private link service connection description.
     * 
     * @param description the description value to set.
     * @return the ManagedInstancePrivateLinkServiceConnectionStateProperty object itself.
     */
    public ManagedInstancePrivateLinkServiceConnectionStateProperty withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actionsRequired property: The private link service connection description.
     * 
     * @return the actionsRequired value.
     */
    public String actionsRequired() {
        return this.actionsRequired;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property status in model ManagedInstancePrivateLinkServiceConnectionStateProperty"));
        }
        if (description() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property description in model ManagedInstancePrivateLinkServiceConnectionStateProperty"));
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(ManagedInstancePrivateLinkServiceConnectionStateProperty.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstancePrivateLinkServiceConnectionStateProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstancePrivateLinkServiceConnectionStateProperty if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the
     * ManagedInstancePrivateLinkServiceConnectionStateProperty.
     */
    public static ManagedInstancePrivateLinkServiceConnectionStateProperty fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstancePrivateLinkServiceConnectionStateProperty deserializedManagedInstancePrivateLinkServiceConnectionStateProperty
                = new ManagedInstancePrivateLinkServiceConnectionStateProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedManagedInstancePrivateLinkServiceConnectionStateProperty.status = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedManagedInstancePrivateLinkServiceConnectionStateProperty.description
                        = reader.getString();
                } else if ("actionsRequired".equals(fieldName)) {
                    deserializedManagedInstancePrivateLinkServiceConnectionStateProperty.actionsRequired
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstancePrivateLinkServiceConnectionStateProperty;
        });
    }
}
