// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentScansExportInner;
import com.azure.resourcemanager.sql.fluent.models.VulnerabilityAssessmentScanRecordInner;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentScanRecordListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * DatabaseVulnerabilityAssessmentScansClient.
 */
public final class DatabaseVulnerabilityAssessmentScansClientImpl
    implements DatabaseVulnerabilityAssessmentScansClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DatabaseVulnerabilityAssessmentScansService service;

    /**
     * The service client containing this operation class.
     */
    private final SqlManagementClientImpl client;

    /**
     * Initializes an instance of DatabaseVulnerabilityAssessmentScansClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DatabaseVulnerabilityAssessmentScansClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(DatabaseVulnerabilityAssessmentScansService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SqlManagementClientDatabaseVulnerabilityAssessmentScans to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SqlManagementClientD")
    public interface DatabaseVulnerabilityAssessmentScansService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<VulnerabilityAssessmentScanRecordListResult>> listByDatabase(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serverName") String serverName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<VulnerabilityAssessmentScanRecordInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serverName") String serverName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("scanId") String scanId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> export(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serverName") String serverName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("scanId") String scanId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> initiateScan(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("serverName") String serverName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("scanId") String scanId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<VulnerabilityAssessmentScanRecordListResult>> listByDatabaseNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseSinglePageAsync(
        String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName,
                databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .<PagedResponse<VulnerabilityAssessmentScanRecordInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>> listByDatabaseSinglePageAsync(
        String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByDatabase(this.client.getEndpoint(), resourceGroupName, serverName, databaseName,
            vulnerabilityAssessmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedFlux<>(() -> listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName,
            vulnerabilityAssessmentName), nextLink -> listByDatabaseNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<VulnerabilityAssessmentScanRecordInner> listByDatabaseAsync(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        Context context) {
        return new PagedFlux<>(
            () -> listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName,
                vulnerabilityAssessmentName, context),
            nextLink -> listByDatabaseNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return new PagedIterable<>(
            listByDatabaseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName));
    }

    /**
     * Lists the vulnerability assessment scans of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        Context context) {
        return new PagedIterable<>(
            listByDatabaseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context));
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName,
                vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<VulnerabilityAssessmentScanRecordInner>> getWithResponseAsync(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName,
            vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<VulnerabilityAssessmentScanRecordInner> getWithResponse(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId,
            context).block();
    }

    /**
     * Gets a vulnerability assessment scan record of a database.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a vulnerability assessment scan record of a database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public VulnerabilityAssessmentScanRecordInner get(String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return getWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId,
            Context.NONE).getValue();
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(
        String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.export(this.client.getEndpoint(), resourceGroupName, serverName,
                databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithResponseAsync(
        String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.export(this.client.getEndpoint(), resourceGroupName, serverName, databaseName,
            vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String scanId) {
        return exportWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentScansExportInner> exportWithResponse(String resourceGroupName,
        String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId,
        Context context) {
        return exportWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId,
            context).block();
    }

    /**
     * Convert an existing scan result to a human readable format. If already exists nothing happens.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the scanned database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database Vulnerability Assessment scan export resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentScansExportInner export(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return exportWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId,
            Context.NONE).getValue();
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.initiateScan(this.client.getEndpoint(), resourceGroupName, serverName,
                databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(),
                this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> initiateScanWithResponseAsync(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error(new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.initiateScan(this.client.getEndpoint(), resourceGroupName, serverName, databaseName,
            vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        Mono<Response<Flux<ByteBuffer>>> mono = initiateScanWithResponseAsync(resourceGroupName, serverName,
            databaseName, vulnerabilityAssessmentName, scanId);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginInitiateScanAsync(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = initiateScanWithResponseAsync(resourceGroupName, serverName,
            databaseName, vulnerabilityAssessmentName, scanId, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginInitiateScan(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return this
            .beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId)
            .getSyncPoller();
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginInitiateScan(String resourceGroupName, String serverName,
        String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return this
            .beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId,
                context)
            .getSyncPoller();
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return beginInitiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void initiateScan(String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        initiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId).block();
    }

    /**
     * Executes a Vulnerability Assessment database scan.
     * 
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     * from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param databaseName The name of the database.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param scanId The vulnerability assessment scan Id of the scan to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void initiateScan(String resourceGroupName, String serverName, String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        initiateScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context)
            .block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>>
        listByDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByDatabaseNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<VulnerabilityAssessmentScanRecordInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of vulnerability assessment scan records along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<VulnerabilityAssessmentScanRecordInner>>
        listByDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByDatabaseNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
