// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A recoverable managed database resource.
 */
@Immutable
public final class RecoverableManagedDatabaseInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private RecoverableManagedDatabaseProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RecoverableManagedDatabaseInner class.
     */
    public RecoverableManagedDatabaseInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private RecoverableManagedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the lastAvailableBackupDate property: The last available backup date.
     * 
     * @return the lastAvailableBackupDate value.
     */
    public String lastAvailableBackupDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastAvailableBackupDate();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecoverableManagedDatabaseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecoverableManagedDatabaseInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RecoverableManagedDatabaseInner.
     */
    public static RecoverableManagedDatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecoverableManagedDatabaseInner deserializedRecoverableManagedDatabaseInner
                = new RecoverableManagedDatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRecoverableManagedDatabaseInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRecoverableManagedDatabaseInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRecoverableManagedDatabaseInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRecoverableManagedDatabaseInner.innerProperties
                        = RecoverableManagedDatabaseProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecoverableManagedDatabaseInner;
        });
    }
}
