// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * A long term retention backup for a managed database.
 */
@Immutable
public final class ManagedInstanceLongTermRetentionBackupInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ManagedInstanceLongTermRetentionBackupProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedInstanceLongTermRetentionBackupInner class.
     */
    public ManagedInstanceLongTermRetentionBackupInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ManagedInstanceLongTermRetentionBackupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the managedInstanceName property: The managed instance that the backup database belongs to.
     * 
     * @return the managedInstanceName value.
     */
    public String managedInstanceName() {
        return this.innerProperties() == null ? null : this.innerProperties().managedInstanceName();
    }

    /**
     * Get the managedInstanceCreateTime property: The create time of the instance.
     * 
     * @return the managedInstanceCreateTime value.
     */
    public OffsetDateTime managedInstanceCreateTime() {
        return this.innerProperties() == null ? null : this.innerProperties().managedInstanceCreateTime();
    }

    /**
     * Get the databaseName property: The name of the database the backup belong to.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Get the databaseDeletionTime property: The delete time of the database.
     * 
     * @return the databaseDeletionTime value.
     */
    public OffsetDateTime databaseDeletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseDeletionTime();
    }

    /**
     * Get the backupTime property: The time the backup was taken.
     * 
     * @return the backupTime value.
     */
    public OffsetDateTime backupTime() {
        return this.innerProperties() == null ? null : this.innerProperties().backupTime();
    }

    /**
     * Get the backupExpirationTime property: The time the long term retention backup will expire.
     * 
     * @return the backupExpirationTime value.
     */
    public OffsetDateTime backupExpirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().backupExpirationTime();
    }

    /**
     * Get the backupStorageRedundancy property: The storage redundancy type of the backup.
     * 
     * @return the backupStorageRedundancy value.
     */
    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().backupStorageRedundancy();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceLongTermRetentionBackupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceLongTermRetentionBackupInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedInstanceLongTermRetentionBackupInner.
     */
    public static ManagedInstanceLongTermRetentionBackupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceLongTermRetentionBackupInner deserializedManagedInstanceLongTermRetentionBackupInner
                = new ManagedInstanceLongTermRetentionBackupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedInstanceLongTermRetentionBackupInner.innerProperties
                        = ManagedInstanceLongTermRetentionBackupProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceLongTermRetentionBackupInner;
        });
    }
}
