// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DiffBackupIntervalInHours;
import java.io.IOException;

/**
 * A short term retention policy.
 */
@Fluent
public final class BackupShortTermRetentionPolicyInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private BackupShortTermRetentionPolicyProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of BackupShortTermRetentionPolicyInner class.
     */
    public BackupShortTermRetentionPolicyInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private BackupShortTermRetentionPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the retentionDays property: The backup retention period in days. This is how many days Point-in-Time Restore
     * will be supported.
     * 
     * @return the retentionDays value.
     */
    public Integer retentionDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionDays();
    }

    /**
     * Set the retentionDays property: The backup retention period in days. This is how many days Point-in-Time Restore
     * will be supported.
     * 
     * @param retentionDays the retentionDays value to set.
     * @return the BackupShortTermRetentionPolicyInner object itself.
     */
    public BackupShortTermRetentionPolicyInner withRetentionDays(Integer retentionDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupShortTermRetentionPolicyProperties();
        }
        this.innerProperties().withRetentionDays(retentionDays);
        return this;
    }

    /**
     * Get the diffBackupIntervalInHours property: The differential backup interval in hours. This is how many interval
     * hours between each differential backup will be supported. This is only applicable to live databases but not
     * dropped databases.
     * 
     * @return the diffBackupIntervalInHours value.
     */
    public DiffBackupIntervalInHours diffBackupIntervalInHours() {
        return this.innerProperties() == null ? null : this.innerProperties().diffBackupIntervalInHours();
    }

    /**
     * Set the diffBackupIntervalInHours property: The differential backup interval in hours. This is how many interval
     * hours between each differential backup will be supported. This is only applicable to live databases but not
     * dropped databases.
     * 
     * @param diffBackupIntervalInHours the diffBackupIntervalInHours value to set.
     * @return the BackupShortTermRetentionPolicyInner object itself.
     */
    public BackupShortTermRetentionPolicyInner
        withDiffBackupIntervalInHours(DiffBackupIntervalInHours diffBackupIntervalInHours) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupShortTermRetentionPolicyProperties();
        }
        this.innerProperties().withDiffBackupIntervalInHours(diffBackupIntervalInHours);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackupShortTermRetentionPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackupShortTermRetentionPolicyInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackupShortTermRetentionPolicyInner.
     */
    public static BackupShortTermRetentionPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackupShortTermRetentionPolicyInner deserializedBackupShortTermRetentionPolicyInner
                = new BackupShortTermRetentionPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBackupShortTermRetentionPolicyInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedBackupShortTermRetentionPolicyInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedBackupShortTermRetentionPolicyInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedBackupShortTermRetentionPolicyInner.innerProperties
                        = BackupShortTermRetentionPolicyProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackupShortTermRetentionPolicyInner;
        });
    }
}
