/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ServerFirewallRuleProperties;
import com.azure.resourcemanager.sql.models.ProxyResourceWithWritableName;
import java.io.IOException;

public final class FirewallRuleInner
extends ProxyResourceWithWritableName {
    private ServerFirewallRuleProperties innerProperties;
    private String type;
    private String id;

    private ServerFirewallRuleProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public FirewallRuleInner withName(String name) {
        super.withName(name);
        return this;
    }

    public String startIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().startIpAddress();
    }

    public FirewallRuleInner withStartIpAddress(String startIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerFirewallRuleProperties();
        }
        this.innerProperties().withStartIpAddress(startIpAddress);
        return this;
    }

    public String endIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().endIpAddress();
    }

    public FirewallRuleInner withEndIpAddress(String endIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerFirewallRuleProperties();
        }
        this.innerProperties().withEndIpAddress(endIpAddress);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FirewallRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallRuleInner)((Object)jsonReader.readObject(reader -> {
            FirewallRuleInner deserializedFirewallRuleInner = new FirewallRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFirewallRuleInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFirewallRuleInner.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFirewallRuleInner.withName(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFirewallRuleInner.innerProperties = ServerFirewallRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallRuleInner;
        }));
    }
}

