// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of column in sync group table.
 */
@Fluent
public final class SyncGroupSchemaTableColumn implements JsonSerializable<SyncGroupSchemaTableColumn> {
    /*
     * Quoted name of sync group table column.
     */
    private String quotedName;

    /*
     * Data size of the column.
     */
    private String dataSize;

    /*
     * Data type of the column.
     */
    private String dataType;

    /**
     * Creates an instance of SyncGroupSchemaTableColumn class.
     */
    public SyncGroupSchemaTableColumn() {
    }

    /**
     * Get the quotedName property: Quoted name of sync group table column.
     * 
     * @return the quotedName value.
     */
    public String quotedName() {
        return this.quotedName;
    }

    /**
     * Set the quotedName property: Quoted name of sync group table column.
     * 
     * @param quotedName the quotedName value to set.
     * @return the SyncGroupSchemaTableColumn object itself.
     */
    public SyncGroupSchemaTableColumn withQuotedName(String quotedName) {
        this.quotedName = quotedName;
        return this;
    }

    /**
     * Get the dataSize property: Data size of the column.
     * 
     * @return the dataSize value.
     */
    public String dataSize() {
        return this.dataSize;
    }

    /**
     * Set the dataSize property: Data size of the column.
     * 
     * @param dataSize the dataSize value to set.
     * @return the SyncGroupSchemaTableColumn object itself.
     */
    public SyncGroupSchemaTableColumn withDataSize(String dataSize) {
        this.dataSize = dataSize;
        return this;
    }

    /**
     * Get the dataType property: Data type of the column.
     * 
     * @return the dataType value.
     */
    public String dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: Data type of the column.
     * 
     * @param dataType the dataType value to set.
     * @return the SyncGroupSchemaTableColumn object itself.
     */
    public SyncGroupSchemaTableColumn withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("quotedName", this.quotedName);
        jsonWriter.writeStringField("dataSize", this.dataSize);
        jsonWriter.writeStringField("dataType", this.dataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncGroupSchemaTableColumn from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncGroupSchemaTableColumn if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncGroupSchemaTableColumn.
     */
    public static SyncGroupSchemaTableColumn fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncGroupSchemaTableColumn deserializedSyncGroupSchemaTableColumn = new SyncGroupSchemaTableColumn();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("quotedName".equals(fieldName)) {
                    deserializedSyncGroupSchemaTableColumn.quotedName = reader.getString();
                } else if ("dataSize".equals(fieldName)) {
                    deserializedSyncGroupSchemaTableColumn.dataSize = reader.getString();
                } else if ("dataType".equals(fieldName)) {
                    deserializedSyncGroupSchemaTableColumn.dataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncGroupSchemaTableColumn;
        });
    }
}
