// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import java.io.IOException;
import java.util.List;

/**
 * The TopQueries model.
 */
@Fluent
public final class TopQueriesInner implements JsonSerializable<TopQueriesInner> {
    /*
     * Requested number of top queries.
     */
    private Integer numberOfQueries;

    /*
     * Aggregation function used to calculate query metrics.
     */
    private String aggregationFunction;

    /*
     * Metric used to rank queries.
     */
    private String observationMetric;

    /*
     * Interval type (length).
     */
    private QueryTimeGrainType intervalType;

    /*
     * The start time for the metric (ISO-8601 format).
     */
    private String startTime;

    /*
     * The end time for the metric (ISO-8601 format).
     */
    private String endTime;

    /*
     * List of top resource consuming queries with appropriate metric data
     */
    private List<QueryStatisticsProperties> queries;

    /**
     * Creates an instance of TopQueriesInner class.
     */
    public TopQueriesInner() {
    }

    /**
     * Get the numberOfQueries property: Requested number of top queries.
     * 
     * @return the numberOfQueries value.
     */
    public Integer numberOfQueries() {
        return this.numberOfQueries;
    }

    /**
     * Get the aggregationFunction property: Aggregation function used to calculate query metrics.
     * 
     * @return the aggregationFunction value.
     */
    public String aggregationFunction() {
        return this.aggregationFunction;
    }

    /**
     * Get the observationMetric property: Metric used to rank queries.
     * 
     * @return the observationMetric value.
     */
    public String observationMetric() {
        return this.observationMetric;
    }

    /**
     * Get the intervalType property: Interval type (length).
     * 
     * @return the intervalType value.
     */
    public QueryTimeGrainType intervalType() {
        return this.intervalType;
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Get the queries property: List of top resource consuming queries with appropriate metric data.
     * 
     * @return the queries value.
     */
    public List<QueryStatisticsProperties> queries() {
        return this.queries;
    }

    /**
     * Set the queries property: List of top resource consuming queries with appropriate metric data.
     * 
     * @param queries the queries value to set.
     * @return the TopQueriesInner object itself.
     */
    public TopQueriesInner withQueries(List<QueryStatisticsProperties> queries) {
        this.queries = queries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (queries() != null) {
            queries().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queries", this.queries, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopQueriesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopQueriesInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopQueriesInner.
     */
    public static TopQueriesInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopQueriesInner deserializedTopQueriesInner = new TopQueriesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("numberOfQueries".equals(fieldName)) {
                    deserializedTopQueriesInner.numberOfQueries = reader.getNullable(JsonReader::getInt);
                } else if ("aggregationFunction".equals(fieldName)) {
                    deserializedTopQueriesInner.aggregationFunction = reader.getString();
                } else if ("observationMetric".equals(fieldName)) {
                    deserializedTopQueriesInner.observationMetric = reader.getString();
                } else if ("intervalType".equals(fieldName)) {
                    deserializedTopQueriesInner.intervalType = QueryTimeGrainType.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedTopQueriesInner.startTime = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedTopQueriesInner.endTime = reader.getString();
                } else if ("queries".equals(fieldName)) {
                    List<QueryStatisticsProperties> queries
                        = reader.readArray(reader1 -> QueryStatisticsProperties.fromJson(reader1));
                    deserializedTopQueriesInner.queries = queries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopQueriesInner;
        });
    }
}
