/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseMaxPerformanceLevelCapability;
import com.azure.resourcemanager.sql.models.LicenseTypeCapability;
import com.azure.resourcemanager.sql.models.MaintenanceConfigurationCapability;
import com.azure.resourcemanager.sql.models.MaxSizeCapability;
import com.azure.resourcemanager.sql.models.MaxSizeRangeCapability;
import com.azure.resourcemanager.sql.models.PerformanceLevelCapability;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.List;

public final class ElasticPoolPerformanceLevelCapability
implements JsonSerializable<ElasticPoolPerformanceLevelCapability> {
    private PerformanceLevelCapability performanceLevel;
    private Sku sku;
    private List<LicenseTypeCapability> supportedLicenseTypes;
    private Integer maxDatabaseCount;
    private MaxSizeCapability includedMaxSize;
    private List<MaxSizeRangeCapability> supportedMaxSizes;
    private List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes;
    private List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels;
    private Boolean zoneRedundant;
    private List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations;
    private CapabilityStatus status;
    private String reason;

    public PerformanceLevelCapability performanceLevel() {
        return this.performanceLevel;
    }

    public Sku sku() {
        return this.sku;
    }

    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    public Integer maxDatabaseCount() {
        return this.maxDatabaseCount;
    }

    public MaxSizeCapability includedMaxSize() {
        return this.includedMaxSize;
    }

    public List<MaxSizeRangeCapability> supportedMaxSizes() {
        return this.supportedMaxSizes;
    }

    public List<MaxSizeRangeCapability> supportedPerDatabaseMaxSizes() {
        return this.supportedPerDatabaseMaxSizes;
    }

    public List<ElasticPoolPerDatabaseMaxPerformanceLevelCapability> supportedPerDatabaseMaxPerformanceLevels() {
        return this.supportedPerDatabaseMaxPerformanceLevels;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations() {
        return this.supportedMaintenanceConfigurations;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ElasticPoolPerformanceLevelCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.performanceLevel() != null) {
            this.performanceLevel().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.supportedLicenseTypes() != null) {
            this.supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (this.includedMaxSize() != null) {
            this.includedMaxSize().validate();
        }
        if (this.supportedMaxSizes() != null) {
            this.supportedMaxSizes().forEach(e -> e.validate());
        }
        if (this.supportedPerDatabaseMaxSizes() != null) {
            this.supportedPerDatabaseMaxSizes().forEach(e -> e.validate());
        }
        if (this.supportedPerDatabaseMaxPerformanceLevels() != null) {
            this.supportedPerDatabaseMaxPerformanceLevels().forEach(e -> e.validate());
        }
        if (this.supportedMaintenanceConfigurations() != null) {
            this.supportedMaintenanceConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolPerformanceLevelCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticPoolPerformanceLevelCapability)jsonReader.readObject(reader -> {
            ElasticPoolPerformanceLevelCapability deserializedElasticPoolPerformanceLevelCapability = new ElasticPoolPerformanceLevelCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("performanceLevel".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.performanceLevel = PerformanceLevelCapability.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("supportedLicenseTypes".equals(fieldName)) {
                    List supportedLicenseTypes;
                    deserializedElasticPoolPerformanceLevelCapability.supportedLicenseTypes = supportedLicenseTypes = reader.readArray(reader1 -> LicenseTypeCapability.fromJson(reader1));
                    continue;
                }
                if ("maxDatabaseCount".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.maxDatabaseCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("includedMaxSize".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.includedMaxSize = MaxSizeCapability.fromJson(reader);
                    continue;
                }
                if ("supportedMaxSizes".equals(fieldName)) {
                    List supportedMaxSizes;
                    deserializedElasticPoolPerformanceLevelCapability.supportedMaxSizes = supportedMaxSizes = reader.readArray(reader1 -> MaxSizeRangeCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedPerDatabaseMaxSizes".equals(fieldName)) {
                    List supportedPerDatabaseMaxSizes;
                    deserializedElasticPoolPerformanceLevelCapability.supportedPerDatabaseMaxSizes = supportedPerDatabaseMaxSizes = reader.readArray(reader1 -> MaxSizeRangeCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedPerDatabaseMaxPerformanceLevels".equals(fieldName)) {
                    List supportedPerDatabaseMaxPerformanceLevels;
                    deserializedElasticPoolPerformanceLevelCapability.supportedPerDatabaseMaxPerformanceLevels = supportedPerDatabaseMaxPerformanceLevels = reader.readArray(reader1 -> ElasticPoolPerDatabaseMaxPerformanceLevelCapability.fromJson(reader1));
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("supportedMaintenanceConfigurations".equals(fieldName)) {
                    List supportedMaintenanceConfigurations;
                    deserializedElasticPoolPerformanceLevelCapability.supportedMaintenanceConfigurations = supportedMaintenanceConfigurations = reader.readArray(reader1 -> MaintenanceConfigurationCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedElasticPoolPerformanceLevelCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolPerformanceLevelCapability;
        });
    }
}

