// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The UpsertManagedServerOperationStepWithEstimatesAndDuration model.
 */
@Fluent
public final class UpsertManagedServerOperationStepWithEstimatesAndDuration
    implements JsonSerializable<UpsertManagedServerOperationStepWithEstimatesAndDuration> {
    /*
     * The stepStartTime property.
     */
    private OffsetDateTime stepStartTime;

    /*
     * The stepEndTime property.
     */
    private OffsetDateTime stepEndTime;

    /*
     * The timeElapsed property.
     */
    private String timeElapsed;

    /*
     * The order property.
     */
    private Integer order;

    /*
     * The name property.
     */
    private String name;

    /*
     * The status property.
     */
    private Status status;

    /**
     * Creates an instance of UpsertManagedServerOperationStepWithEstimatesAndDuration class.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration() {
    }

    /**
     * Get the stepStartTime property: The stepStartTime property.
     * 
     * @return the stepStartTime value.
     */
    public OffsetDateTime stepStartTime() {
        return this.stepStartTime;
    }

    /**
     * Set the stepStartTime property: The stepStartTime property.
     * 
     * @param stepStartTime the stepStartTime value to set.
     * @return the UpsertManagedServerOperationStepWithEstimatesAndDuration object itself.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration withStepStartTime(OffsetDateTime stepStartTime) {
        this.stepStartTime = stepStartTime;
        return this;
    }

    /**
     * Get the stepEndTime property: The stepEndTime property.
     * 
     * @return the stepEndTime value.
     */
    public OffsetDateTime stepEndTime() {
        return this.stepEndTime;
    }

    /**
     * Set the stepEndTime property: The stepEndTime property.
     * 
     * @param stepEndTime the stepEndTime value to set.
     * @return the UpsertManagedServerOperationStepWithEstimatesAndDuration object itself.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration withStepEndTime(OffsetDateTime stepEndTime) {
        this.stepEndTime = stepEndTime;
        return this;
    }

    /**
     * Get the timeElapsed property: The timeElapsed property.
     * 
     * @return the timeElapsed value.
     */
    public String timeElapsed() {
        return this.timeElapsed;
    }

    /**
     * Set the timeElapsed property: The timeElapsed property.
     * 
     * @param timeElapsed the timeElapsed value to set.
     * @return the UpsertManagedServerOperationStepWithEstimatesAndDuration object itself.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration withTimeElapsed(String timeElapsed) {
        this.timeElapsed = timeElapsed;
        return this;
    }

    /**
     * Get the order property: The order property.
     * 
     * @return the order value.
     */
    public Integer order() {
        return this.order;
    }

    /**
     * Set the order property: The order property.
     * 
     * @param order the order value to set.
     * @return the UpsertManagedServerOperationStepWithEstimatesAndDuration object itself.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration withOrder(Integer order) {
        this.order = order;
        return this;
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the UpsertManagedServerOperationStepWithEstimatesAndDuration object itself.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the status property: The status property.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.status;
    }

    /**
     * Set the status property: The status property.
     * 
     * @param status the status value to set.
     * @return the UpsertManagedServerOperationStepWithEstimatesAndDuration object itself.
     */
    public UpsertManagedServerOperationStepWithEstimatesAndDuration withStatus(Status status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("stepStartTime",
            this.stepStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stepStartTime));
        jsonWriter.writeStringField("stepEndTime",
            this.stepEndTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.stepEndTime));
        jsonWriter.writeStringField("timeElapsed", this.timeElapsed);
        jsonWriter.writeNumberField("order", this.order);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpsertManagedServerOperationStepWithEstimatesAndDuration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpsertManagedServerOperationStepWithEstimatesAndDuration if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * UpsertManagedServerOperationStepWithEstimatesAndDuration.
     */
    public static UpsertManagedServerOperationStepWithEstimatesAndDuration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            UpsertManagedServerOperationStepWithEstimatesAndDuration deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration
                = new UpsertManagedServerOperationStepWithEstimatesAndDuration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("stepStartTime".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.stepStartTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("stepEndTime".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.stepEndTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("timeElapsed".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.timeElapsed
                        = reader.getString();
                } else if ("order".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.order
                        = reader.getNullable(JsonReader::getInt);
                } else if ("name".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration.status
                        = Status.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpsertManagedServerOperationStepWithEstimatesAndDuration;
        });
    }
}
