// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.FailoverGroupUpdateProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * A failover group update request.
 */
@Fluent
public final class FailoverGroupUpdate implements JsonSerializable<FailoverGroupUpdate> {
    /*
     * Resource properties.
     */
    private FailoverGroupUpdateProperties innerProperties;

    /*
     * Resource tags.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of FailoverGroupUpdate class.
     */
    public FailoverGroupUpdate() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private FailoverGroupUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the FailoverGroupUpdate object itself.
     */
    public FailoverGroupUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     * 
     * @return the readWriteEndpoint value.
     */
    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().readWriteEndpoint();
    }

    /**
     * Set the readWriteEndpoint property: Read-write endpoint of the failover group instance.
     * 
     * @param readWriteEndpoint the readWriteEndpoint value to set.
     * @return the FailoverGroupUpdate object itself.
     */
    public FailoverGroupUpdate withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupUpdateProperties();
        }
        this.innerProperties().withReadWriteEndpoint(readWriteEndpoint);
        return this;
    }

    /**
     * Get the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     * 
     * @return the readOnlyEndpoint value.
     */
    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().readOnlyEndpoint();
    }

    /**
     * Set the readOnlyEndpoint property: Read-only endpoint of the failover group instance.
     * 
     * @param readOnlyEndpoint the readOnlyEndpoint value to set.
     * @return the FailoverGroupUpdate object itself.
     */
    public FailoverGroupUpdate withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupUpdateProperties();
        }
        this.innerProperties().withReadOnlyEndpoint(readOnlyEndpoint);
        return this;
    }

    /**
     * Get the databases property: List of databases in the failover group.
     * 
     * @return the databases value.
     */
    public List<String> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    /**
     * Set the databases property: List of databases in the failover group.
     * 
     * @param databases the databases value to set.
     * @return the FailoverGroupUpdate object itself.
     */
    public FailoverGroupUpdate withDatabases(List<String> databases) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupUpdateProperties();
        }
        this.innerProperties().withDatabases(databases);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FailoverGroupUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FailoverGroupUpdate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FailoverGroupUpdate.
     */
    public static FailoverGroupUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FailoverGroupUpdate deserializedFailoverGroupUpdate = new FailoverGroupUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedFailoverGroupUpdate.innerProperties = FailoverGroupUpdateProperties.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFailoverGroupUpdate.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFailoverGroupUpdate;
        });
    }
}
