// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A managed server DNS alias.
 */
@Immutable
public final class ManagedServerDnsAliasInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private ManagedServerDnsAliasProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ManagedServerDnsAliasInner class.
     */
    public ManagedServerDnsAliasInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private ManagedServerDnsAliasProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the azureDnsRecord property: The fully qualified DNS record for managed server alias.
     * 
     * @return the azureDnsRecord value.
     */
    public String azureDnsRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().azureDnsRecord();
    }

    /**
     * Get the publicAzureDnsRecord property: The fully qualified public DNS record for managed server alias.
     * 
     * @return the publicAzureDnsRecord value.
     */
    public String publicAzureDnsRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().publicAzureDnsRecord();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedServerDnsAliasInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedServerDnsAliasInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedServerDnsAliasInner.
     */
    public static ManagedServerDnsAliasInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedServerDnsAliasInner deserializedManagedServerDnsAliasInner = new ManagedServerDnsAliasInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedServerDnsAliasInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedServerDnsAliasInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedServerDnsAliasInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedServerDnsAliasInner.innerProperties
                        = ManagedServerDnsAliasProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedServerDnsAliasInner;
        });
    }
}
