// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a database Vulnerability Assessment rule baseline.
 */
@Fluent
public final class DatabaseVulnerabilityAssessmentRuleBaselineProperties
    implements JsonSerializable<DatabaseVulnerabilityAssessmentRuleBaselineProperties> {
    /*
     * The rule baseline result
     */
    private List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults;

    /**
     * Creates an instance of DatabaseVulnerabilityAssessmentRuleBaselineProperties class.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineProperties() {
    }

    /**
     * Get the baselineResults property: The rule baseline result.
     * 
     * @return the baselineResults value.
     */
    public List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults() {
        return this.baselineResults;
    }

    /**
     * Set the baselineResults property: The rule baseline result.
     * 
     * @param baselineResults the baselineResults value to set.
     * @return the DatabaseVulnerabilityAssessmentRuleBaselineProperties object itself.
     */
    public DatabaseVulnerabilityAssessmentRuleBaselineProperties
        withBaselineResults(List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        this.baselineResults = baselineResults;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (baselineResults() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property baselineResults in model DatabaseVulnerabilityAssessmentRuleBaselineProperties"));
        } else {
            baselineResults().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(DatabaseVulnerabilityAssessmentRuleBaselineProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("baselineResults", this.baselineResults,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseVulnerabilityAssessmentRuleBaselineProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseVulnerabilityAssessmentRuleBaselineProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseVulnerabilityAssessmentRuleBaselineProperties.
     */
    public static DatabaseVulnerabilityAssessmentRuleBaselineProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseVulnerabilityAssessmentRuleBaselineProperties deserializedDatabaseVulnerabilityAssessmentRuleBaselineProperties
                = new DatabaseVulnerabilityAssessmentRuleBaselineProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baselineResults".equals(fieldName)) {
                    List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults = reader
                        .readArray(reader1 -> DatabaseVulnerabilityAssessmentRuleBaselineItem.fromJson(reader1));
                    deserializedDatabaseVulnerabilityAssessmentRuleBaselineProperties.baselineResults = baselineResults;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseVulnerabilityAssessmentRuleBaselineProperties;
        });
    }
}
