/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.InstancePoolLicenseType;
import java.io.IOException;

public final class InstancePoolProperties
implements JsonSerializable<InstancePoolProperties> {
    private String subnetId;
    private int vCores;
    private InstancePoolLicenseType licenseType;
    private static final ClientLogger LOGGER = new ClientLogger(InstancePoolProperties.class);

    public String subnetId() {
        return this.subnetId;
    }

    public InstancePoolProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public int vCores() {
        return this.vCores;
    }

    public InstancePoolProperties withVCores(int vCores) {
        this.vCores = vCores;
        return this;
    }

    public InstancePoolLicenseType licenseType() {
        return this.licenseType;
    }

    public InstancePoolProperties withLicenseType(InstancePoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public void validate() {
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model InstancePoolProperties"));
        }
        if (this.licenseType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property licenseType in model InstancePoolProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeIntField("vCores", this.vCores);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        return jsonWriter.writeEndObject();
    }

    public static InstancePoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InstancePoolProperties)jsonReader.readObject(reader -> {
            InstancePoolProperties deserializedInstancePoolProperties = new InstancePoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedInstancePoolProperties.subnetId = reader.getString();
                    continue;
                }
                if ("vCores".equals(fieldName)) {
                    deserializedInstancePoolProperties.vCores = reader.getInt();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedInstancePoolProperties.licenseType = InstancePoolLicenseType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstancePoolProperties;
        });
    }
}

