// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.OutboundFirewallRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of outbound rules.
 */
@Immutable
public final class OutboundFirewallRuleListResult implements JsonSerializable<OutboundFirewallRuleListResult> {
    /*
     * Array of results.
     */
    private List<OutboundFirewallRuleInner> value;

    /*
     * Link to retrieve next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of OutboundFirewallRuleListResult class.
     */
    public OutboundFirewallRuleListResult() {
    }

    /**
     * Get the value property: Array of results.
     * 
     * @return the value value.
     */
    public List<OutboundFirewallRuleInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to retrieve next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OutboundFirewallRuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OutboundFirewallRuleListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OutboundFirewallRuleListResult.
     */
    public static OutboundFirewallRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OutboundFirewallRuleListResult deserializedOutboundFirewallRuleListResult
                = new OutboundFirewallRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<OutboundFirewallRuleInner> value
                        = reader.readArray(reader1 -> OutboundFirewallRuleInner.fromJson(reader1));
                    deserializedOutboundFirewallRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedOutboundFirewallRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOutboundFirewallRuleListResult;
        });
    }
}
